
#include <SoftwareSerial.h>
#include <Servo.h>

Servo myservo;
Servo esc;
SoftwareSerial BTSerial(10, 11);
long int var ;
String data;
String valys = "0", valxs = "0";
int valy, valx;

void setup() 
{
  myservo.attach(8);
  BTSerial.begin(38400);
  Serial.begin(38400);
  esc.attach(5);
  esc.writeMicroseconds(1000);
  if (BTSerial.available() > 0)
  {
    data = BTSerial.readStringUntil('\n');
  }
  //Disregard the first reading
  data = "0";
}


void loop() 
{
 if (BTSerial.available() > 0)
  { 
    data = BTSerial.readStringUntil('\n');  
  }
  String payload = ""; 
  if (data != "0")
  {
    int offset = data.indexOf("U*"); //This is the header (0x552A)
    if (offset >= 0)
    {
      payload = data.substring(offset + 3, data.indexOf('\n'));
      char value = data.charAt (offset + 2);
      switch (value)
      {
        case 'A':
          valys = payload;
          break;
        case 'B':
          valxs = payload;
          break;
      //Add more case as the project grow
      }
    }
  }
  //convert strings to float
  valy = valys.toInt();
  valy = map(valy, 0, 1024, 110, 255);
  valx = valxs.toInt();
  Serial.println(valx);
  Serial.println(valy);
  myservo.write(valx);
  esc.write(valy);
 
}
