﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;


namespace serial_port_photocell
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            serialPort1.PortName = comboBox1.Text;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            serialPort1.BaudRate = 115200;
            serialPort1.Parity = Parity.None;
            serialPort1.DataBits = 8;
            serialPort1.StopBits = StopBits.One;
            Disconnect.Enabled = false;
            Disconnect.Enabled = false;
            Receive.Enabled = false;
            comboBox1.Items.AddRange(SerialPort.GetPortNames());
            textBox2.Text = "Device Disconnected!";

        }

        private void Connect_Click(object sender, EventArgs e)
        {
            serialPort1.Open();
            Connect.Enabled = false;
            Disconnect.Enabled = true;
            Receive.Enabled = true;
            textBox2.Text = "Connecting......";

        }

        private void Receive_Click(object sender, EventArgs e)
        {
            timer1.Enabled = true;
        }

        private void EXIT_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            textBox1.Text = serialPort1.ReadLine();
            int i = System.Convert.ToInt32(textBox1.Text);
            progressBar1.Value = i;

        }

        private void Disconnect_Click(object sender, EventArgs e)
        {
            serialPort1.Close();
            Disconnect.Enabled = false;
            Receive.Enabled = false;
            textBox2.Text = "Disconntetion";
            timer1.Enabled = false;

        }
    }
}
