package org.snowcorp.imageupload;

/**
 * Created by marksarturocalderonniquin on 4/13/17.
 */


import android.os.Message;
import android.util.Log;

import java.io.IOException;
import java.io.StringReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UdpClientThread extends Thread {

    String dstAddress;
    int dstPort;
    private boolean running;
    MainActivity.UdpClientHandler handler;

    DatagramSocket socket;
    InetAddress address;

    public UdpClientThread(String addr, int port, MainActivity.UdpClientHandler handler) {
        super();
        dstAddress = addr;
        dstPort = port;
        this.handler = handler;
        Log.i("address",addr);
        Log.i("port", String.valueOf(port));
    }

    public void setRunning(boolean running){
        this.running = running;
    }

    private void sendState(String state){
        handler.sendMessage(
                Message.obtain(handler,
                        MainActivity.UdpClientHandler.UPDATE_STATE, state));
    }

    @Override
    public void run() {
        sendState("connecting...");
        Log.i("udp","running");

        running = true;

        try {
            socket = new DatagramSocket(dstPort);
            address = InetAddress.getByName(dstAddress);
            if(address.isReachable(1000))
                Log.i("udp","reachable");
            else
                Log.i("udp","unreachable");

            // send request
            byte[] buf = new byte[1024];



            sendState("connected");

            // get response

            String resp = "OK";
            String resp2 = "SESSION";

            while (true) {
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                socket.receive(packet);

                String line = new String(packet.getData(), 0, packet.getLength());
                Log.i("mensaje", line);


                if (line.contains("OK"))
                {
                    Log.i("contenido","ok");

                    handler.sendMessage(
                            Message.obtain(handler, MainActivity.UdpClientHandler.UPDATE_MSG, line));
                }
                else if (line.contains(resp2)){
                    String[] lists = line.split(",");
                    for (String ss:lists
                         ) {
                        Log.i("lis", ss);
                    }
                    //SESSION,NAME_SESSION
                    handler.sendMessage(
                            Message.obtain(handler, MainActivity.UdpClientHandler.START_SESSION, lists[1]));
                }
                else if(line.contains("END")){
                    handler.sendMessage(
                            Message.obtain(handler, MainActivity.UdpClientHandler.END_SESSION, line));
                }

                java.lang.Thread.sleep(1000L);
                //packet = null;
            }


        } catch (SocketException e) {
            e.printStackTrace();
        } catch (UnknownHostException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } /*finally {
            if(socket != null){
                Log.i("udp","close socket");
                socket.close();
                handler.sendEmptyMessage(MainActivity.UdpClientHandler.UPDATE_END);
            }
        }*/
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Log.i("udp","end cycle");

    }

}
