package org.snowcorp.imageupload;

/**
 * Created by marksarturocalderonniquin on 4/14/17.
 */

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import java.util.ArrayList;
import java.util.List;

public class DBHandler extends SQLiteOpenHelper {

    // Database Version
    private static final int DATABASE_VERSION = 1;
    // Database Name
    private static final String DATABASE_NAME = "fruit3d";
    // Contacts table name
    private static final String TABLE_OBJECT = "object";
    // Shops Table Columns names
    private static final String KEY_ID = "id";
    private static final String KEY_NAME = "name";
    private static final String KEY_PATH = "path";
    public DBHandler(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
    }
    @Override
    public void onCreate(SQLiteDatabase db) {
        String CREATE_CONTACTS_TABLE = "CREATE TABLE " + TABLE_OBJECT + "("
        + KEY_ID + " INTEGER PRIMARY KEY," + KEY_NAME + " TEXT NOT NULL,"
        + KEY_PATH + " TEXT NOT NULL" + ")";
        db.execSQL(CREATE_CONTACTS_TABLE);
    }
    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
// Drop older table if existed
        db.execSQL("DROP TABLE IF EXISTS " + TABLE_OBJECT);
// Creating tables again
        onCreate(db);
    }

    // Adding new object
    public void addObject(ImageSFM shop) {
        SQLiteDatabase db = this.getWritableDatabase();

        ContentValues values = new ContentValues();
        values.put(KEY_NAME, shop.getName()); // session name
        values.put(KEY_PATH, shop.getPath()); // path image

// Inserting Row
        db.insert(TABLE_OBJECT, null, values);
        db.close(); // Closing database connection
    }
    // Getting one image
    public ImageSFM getImageSFM(int id) {
        SQLiteDatabase db = this.getReadableDatabase();

        Cursor cursor = db.query(TABLE_OBJECT, new String[]{KEY_ID,
                KEY_NAME, KEY_PATH}, KEY_ID + "=?",
        new String[]{String.valueOf(id)}, null, null, null, null);
        if (cursor != null)
            cursor.moveToFirst();

        ImageSFM contact = new ImageSFM(Integer.parseInt(cursor.getString(0)),
                cursor.getString(1), cursor.getString(2));
// return image
        return contact;
    }

    // Getting all images
    public List<ImageSFM> getImageSFM(String pj) {
        List<ImageSFM> shopList = new ArrayList<ImageSFM>();
// Select All Query
        SQLiteDatabase db = this.getReadableDatabase();

        Cursor cursor = db.query(TABLE_OBJECT, new String[]{KEY_ID,
                        KEY_NAME, KEY_PATH}, KEY_PATH + "=?",
                new String[]{pj}, null, null, null, null);

        if (cursor.moveToFirst()) {
            do {
                ImageSFM shop = new ImageSFM();
                shop.setId(Integer.parseInt(cursor.getString(0)));
                shop.setName(cursor.getString(1));
                shop.setPath(cursor.getString(2));
// Adding contact to list
                shopList.add(shop);
            } while (cursor.moveToNext());
        }

        return shopList;
    }



    // Getting All Objects
    public List<ImageSFM> getAllObjects() {
        List<ImageSFM> shopList = new ArrayList<ImageSFM>();
// Select All Query
        String selectQuery = "SELECT * FROM " + TABLE_OBJECT;

        SQLiteDatabase db = this.getWritableDatabase();
        Cursor cursor = db.rawQuery(selectQuery, null);

// looping through all rows and adding to list
        if (cursor.moveToFirst()) {
            do {
                ImageSFM shop = new ImageSFM();
                shop.setId(Integer.parseInt(cursor.getString(0)));
                shop.setName(cursor.getString(1));
                shop.setPath(cursor.getString(2));
// Adding contact to list
                shopList.add(shop);
            } while (cursor.moveToNext());
        }

// return contact list
        return shopList;
    }
    // Getting shops Count
    public int getObjectsCount() {
        String countQuery = "SELECT * FROM " + TABLE_OBJECT;
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.rawQuery(countQuery, null);
        cursor.close();

// return count
        return cursor.getCount();
    }
    // Updating an object
    public int updateObject(ImageSFM shop) {
        SQLiteDatabase db = this.getWritableDatabase();

        ContentValues values = new ContentValues();
        values.put(KEY_NAME, shop.getName());
        values.put(KEY_PATH, shop.getPath());

// updating row
        return db.update(TABLE_OBJECT, values, KEY_ID + " = ?",
        new String[]{String.valueOf(shop.getId())});
    }

    // Deleting an object
    public void delete(ImageSFM shop) {
        SQLiteDatabase db = this.getWritableDatabase();
        db.delete(TABLE_OBJECT, KEY_ID + " = ?",
        new String[] { String.valueOf(shop.getId()) });
        db.close();
    }
}

