/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v7.appcompat.R;
import android.support.v7.widget.AppCompatDrawableManager;
import android.support.v7.widget.DrawableUtils;
import android.support.v7.widget.TintTypedArray;
import android.util.AttributeSet;
import android.widget.ImageView;

public class AppCompatImageHelper {
    private final ImageView mView;
    private final AppCompatDrawableManager mDrawableManager;

    public AppCompatImageHelper(ImageView view, AppCompatDrawableManager drawableManager) {
        this.mView = view;
        this.mDrawableManager = drawableManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromAttributes(AttributeSet attrs, int defStyleAttr) {
        TintTypedArray a = null;
        try {
            int id2;
            Drawable drawable2 = this.mView.getDrawable();
            if (drawable2 == null && (id2 = (a = TintTypedArray.obtainStyledAttributes(this.mView.getContext(), attrs, R.styleable.AppCompatImageView, defStyleAttr, 0)).getResourceId(R.styleable.AppCompatImageView_srcCompat, -1)) != -1 && (drawable2 = this.mDrawableManager.getDrawable(this.mView.getContext(), id2)) != null) {
                this.mView.setImageDrawable(drawable2);
            }
            if (drawable2 != null) {
                DrawableUtils.fixDrawable(drawable2);
            }
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
    }

    public void setImageResource(int resId) {
        if (resId != 0) {
            Drawable d;
            Drawable drawable2 = d = this.mDrawableManager != null ? this.mDrawableManager.getDrawable(this.mView.getContext(), resId) : ContextCompat.getDrawable((Context)this.mView.getContext(), (int)resId);
            if (d != null) {
                DrawableUtils.fixDrawable(d);
            }
            this.mView.setImageDrawable(d);
        } else {
            this.mView.setImageDrawable(null);
        }
    }

    boolean hasOverlappingRendering() {
        Drawable background = this.mView.getBackground();
        return Build.VERSION.SDK_INT < 21 || !(background instanceof RippleDrawable);
    }
}

