/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.graphics.Rect;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class FragmentTransitionCompat21 {
    FragmentTransitionCompat21() {
    }

    public static String getTransitionName(View view) {
        return view.getTransitionName();
    }

    public static Object cloneTransition(Object transition) {
        if (transition != null) {
            transition = ((Transition)transition).clone();
        }
        return transition;
    }

    public static Object captureExitingViews(Object exitTransition, View root, ArrayList<View> viewList, Map<String, View> namedViews, View nonExistentView) {
        if (exitTransition != null) {
            FragmentTransitionCompat21.captureTransitioningViews(viewList, root);
            if (namedViews != null) {
                viewList.removeAll(namedViews.values());
            }
            if (viewList.isEmpty()) {
                exitTransition = null;
            } else {
                viewList.add(nonExistentView);
                FragmentTransitionCompat21.addTargets((Transition)exitTransition, viewList);
            }
        }
        return exitTransition;
    }

    public static void excludeTarget(Object transitionObject, View view, boolean exclude) {
        Transition transition = (Transition)transitionObject;
        transition.excludeTarget(view, exclude);
    }

    public static void beginDelayedTransition(ViewGroup sceneRoot, Object transitionObject) {
        Transition transition = (Transition)transitionObject;
        TransitionManager.beginDelayedTransition((ViewGroup)sceneRoot, (Transition)transition);
    }

    public static void setEpicenter(Object transitionObject, View view) {
        Transition transition = (Transition)transitionObject;
        final Rect epicenter = FragmentTransitionCompat21.getBoundsOnScreen(view);
        transition.setEpicenterCallback(new Transition.EpicenterCallback(){

            public Rect onGetEpicenter(Transition transition) {
                return epicenter;
            }
        });
    }

    public static Object wrapSharedElementTransition(Object transitionObj) {
        if (transitionObj == null) {
            return null;
        }
        Transition transition = (Transition)transitionObj;
        if (transition == null) {
            return null;
        }
        TransitionSet transitionSet = new TransitionSet();
        transitionSet.addTransition(transition);
        return transitionSet;
    }

    private static void excludeViews(Transition transition, Transition fromTransition, ArrayList<View> views, boolean exclude) {
        if (transition != null) {
            int viewCount = fromTransition == null ? 0 : views.size();
            for (int i = 0; i < viewCount; ++i) {
                transition.excludeTarget(views.get(i), exclude);
            }
        }
    }

    public static void excludeSharedElementViews(Object enterTransitionObj, Object exitTransitionObj, Object sharedElementTransitionObj, ArrayList<View> views, boolean exclude) {
        Transition enterTransition = (Transition)enterTransitionObj;
        Transition exitTransition = (Transition)exitTransitionObj;
        Transition sharedElementTransition = (Transition)sharedElementTransitionObj;
        FragmentTransitionCompat21.excludeViews(enterTransition, sharedElementTransition, views, exclude);
        FragmentTransitionCompat21.excludeViews(exitTransition, sharedElementTransition, views, exclude);
    }

    public static void addTransitionTargets(Object enterTransitionObject, Object sharedElementTransitionObject, Object exitTransitionObject, final View container, final ViewRetriever inFragment, final View nonExistentView, EpicenterView epicenterView, final Map<String, String> nameOverrides, final ArrayList<View> enteringViews, ArrayList<View> exitingViews, Map<String, View> namedViews, final Map<String, View> renamedViews, ArrayList<View> sharedElementTargets) {
        final Transition enterTransition = (Transition)enterTransitionObject;
        final Transition exitTransition = (Transition)exitTransitionObject;
        Transition sharedElementTransition = (Transition)sharedElementTransitionObject;
        FragmentTransitionCompat21.excludeViews(enterTransition, exitTransition, exitingViews, true);
        if (enterTransitionObject != null || sharedElementTransitionObject != null) {
            if (enterTransition != null) {
                enterTransition.addTarget(nonExistentView);
            }
            if (sharedElementTransitionObject != null) {
                FragmentTransitionCompat21.setSharedElementTargets(sharedElementTransition, nonExistentView, namedViews, sharedElementTargets);
                FragmentTransitionCompat21.excludeViews(enterTransition, sharedElementTransition, sharedElementTargets, true);
                FragmentTransitionCompat21.excludeViews(exitTransition, sharedElementTransition, sharedElementTargets, true);
            }
            container.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    View fragmentView;
                    container.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    if (enterTransition != null) {
                        enterTransition.removeTarget(nonExistentView);
                    }
                    if (inFragment != null && (fragmentView = inFragment.getView()) != null) {
                        if (!nameOverrides.isEmpty()) {
                            FragmentTransitionCompat21.findNamedViews(renamedViews, fragmentView);
                            renamedViews.keySet().retainAll(nameOverrides.values());
                            for (Map.Entry entry : nameOverrides.entrySet()) {
                                String to = (String)entry.getValue();
                                View view = (View)renamedViews.get(to);
                                if (view == null) continue;
                                String from = (String)entry.getKey();
                                view.setTransitionName(from);
                            }
                        }
                        if (enterTransition != null) {
                            FragmentTransitionCompat21.captureTransitioningViews(enteringViews, fragmentView);
                            enteringViews.removeAll(renamedViews.values());
                            enteringViews.add(nonExistentView);
                            FragmentTransitionCompat21.addTargets(enterTransition, enteringViews);
                        }
                    }
                    FragmentTransitionCompat21.excludeViews(exitTransition, enterTransition, enteringViews, true);
                    return true;
                }
            });
            FragmentTransitionCompat21.setSharedElementEpicenter(enterTransition, epicenterView);
        }
    }

    public static Object mergeTransitions(Object enterTransitionObject, Object exitTransitionObject, Object sharedElementTransitionObject, boolean allowOverlap) {
        TransitionSet transition;
        boolean overlap = true;
        Transition enterTransition = (Transition)enterTransitionObject;
        Transition exitTransition = (Transition)exitTransitionObject;
        Transition sharedElementTransition = (Transition)sharedElementTransitionObject;
        if (enterTransition != null && exitTransition != null) {
            overlap = allowOverlap;
        }
        if (overlap) {
            TransitionSet transitionSet = new TransitionSet();
            if (enterTransition != null) {
                transitionSet.addTransition(enterTransition);
            }
            if (exitTransition != null) {
                transitionSet.addTransition(exitTransition);
            }
            if (sharedElementTransition != null) {
                transitionSet.addTransition(sharedElementTransition);
            }
            transition = transitionSet;
        } else {
            Transition staggered = null;
            if (exitTransition != null && enterTransition != null) {
                staggered = new TransitionSet().addTransition(exitTransition).addTransition(enterTransition).setOrdering(1);
            } else if (exitTransition != null) {
                staggered = exitTransition;
            } else if (enterTransition != null) {
                staggered = enterTransition;
            }
            if (sharedElementTransition != null) {
                TransitionSet together = new TransitionSet();
                if (staggered != null) {
                    together.addTransition(staggered);
                }
                together.addTransition(sharedElementTransition);
                transition = together;
            } else {
                transition = staggered;
            }
        }
        return transition;
    }

    public static void setSharedElementTargets(Object transitionObj, View nonExistentView, Map<String, View> namedViews, ArrayList<View> sharedElementTargets) {
        TransitionSet transition = (TransitionSet)transitionObj;
        sharedElementTargets.clear();
        sharedElementTargets.addAll(namedViews.values());
        List views = transition.getTargets();
        views.clear();
        int count = sharedElementTargets.size();
        for (int i = 0; i < count; ++i) {
            View view = sharedElementTargets.get(i);
            FragmentTransitionCompat21.bfsAddViewChildren(views, view);
        }
        sharedElementTargets.add(nonExistentView);
        FragmentTransitionCompat21.addTargets(transition, sharedElementTargets);
    }

    private static void bfsAddViewChildren(List<View> views, View startView) {
        int startIndex = views.size();
        if (FragmentTransitionCompat21.containedBeforeIndex(views, startView, startIndex)) {
            return;
        }
        views.add(startView);
        for (int index = startIndex; index < views.size(); ++index) {
            View view = views.get(index);
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup viewGroup = (ViewGroup)view;
            int childCount = viewGroup.getChildCount();
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                View child = viewGroup.getChildAt(childIndex);
                if (FragmentTransitionCompat21.containedBeforeIndex(views, child, startIndex)) continue;
                views.add(child);
            }
        }
    }

    private static boolean containedBeforeIndex(List<View> views, View view, int maxIndex) {
        for (int i = 0; i < maxIndex; ++i) {
            if (views.get(i) != view) continue;
            return true;
        }
        return false;
    }

    private static void setSharedElementEpicenter(Transition transition, final EpicenterView epicenterView) {
        if (transition != null) {
            transition.setEpicenterCallback(new Transition.EpicenterCallback(){
                private Rect mEpicenter;

                public Rect onGetEpicenter(Transition transition) {
                    if (this.mEpicenter == null && epicenterView.epicenter != null) {
                        this.mEpicenter = FragmentTransitionCompat21.getBoundsOnScreen(epicenterView.epicenter);
                    }
                    return this.mEpicenter;
                }
            });
        }
    }

    private static Rect getBoundsOnScreen(View view) {
        Rect epicenter = new Rect();
        int[] loc = new int[2];
        view.getLocationOnScreen(loc);
        epicenter.set(loc[0], loc[1], loc[0] + view.getWidth(), loc[1] + view.getHeight());
        return epicenter;
    }

    private static void captureTransitioningViews(ArrayList<View> transitioningViews, View view) {
        if (view.getVisibility() == 0) {
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                if (viewGroup.isTransitionGroup()) {
                    transitioningViews.add((View)viewGroup);
                } else {
                    int count = viewGroup.getChildCount();
                    for (int i = 0; i < count; ++i) {
                        View child = viewGroup.getChildAt(i);
                        FragmentTransitionCompat21.captureTransitioningViews(transitioningViews, child);
                    }
                }
            } else {
                transitioningViews.add(view);
            }
        }
    }

    public static void findNamedViews(Map<String, View> namedViews, View view) {
        if (view.getVisibility() == 0) {
            String transitionName = view.getTransitionName();
            if (transitionName != null) {
                namedViews.put(transitionName, view);
            }
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                int count = viewGroup.getChildCount();
                for (int i = 0; i < count; ++i) {
                    View child = viewGroup.getChildAt(i);
                    FragmentTransitionCompat21.findNamedViews(namedViews, child);
                }
            }
        }
    }

    public static void cleanupTransitions(final View sceneRoot, final View nonExistentView, Object enterTransitionObject, final ArrayList<View> enteringViews, Object exitTransitionObject, final ArrayList<View> exitingViews, Object sharedElementTransitionObject, final ArrayList<View> sharedElementTargets, Object overallTransitionObject, final ArrayList<View> hiddenViews, final Map<String, View> renamedViews) {
        final Transition enterTransition = (Transition)enterTransitionObject;
        final Transition exitTransition = (Transition)exitTransitionObject;
        final Transition sharedElementTransition = (Transition)sharedElementTransitionObject;
        final Transition overallTransition = (Transition)overallTransitionObject;
        if (overallTransition != null) {
            sceneRoot.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    sceneRoot.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    if (enterTransition != null) {
                        FragmentTransitionCompat21.removeTargets(enterTransition, enteringViews);
                        FragmentTransitionCompat21.excludeViews(enterTransition, exitTransition, exitingViews, false);
                        FragmentTransitionCompat21.excludeViews(enterTransition, sharedElementTransition, sharedElementTargets, false);
                    }
                    if (exitTransition != null) {
                        FragmentTransitionCompat21.removeTargets(exitTransition, exitingViews);
                        FragmentTransitionCompat21.excludeViews(exitTransition, enterTransition, enteringViews, false);
                        FragmentTransitionCompat21.excludeViews(exitTransition, sharedElementTransition, sharedElementTargets, false);
                    }
                    if (sharedElementTransition != null) {
                        FragmentTransitionCompat21.removeTargets(sharedElementTransition, sharedElementTargets);
                    }
                    for (Map.Entry entry : renamedViews.entrySet()) {
                        View view = (View)entry.getValue();
                        String name = (String)entry.getKey();
                        view.setTransitionName(name);
                    }
                    int numViews = hiddenViews.size();
                    for (int i = 0; i < numViews; ++i) {
                        overallTransition.excludeTarget((View)hiddenViews.get(i), false);
                    }
                    overallTransition.excludeTarget(nonExistentView, false);
                    return true;
                }
            });
        }
    }

    public static void removeTargets(Object transitionObject, ArrayList<View> views) {
        block3: {
            List targets;
            Transition transition;
            block2: {
                transition = (Transition)transitionObject;
                if (!(transition instanceof TransitionSet)) break block2;
                TransitionSet set = (TransitionSet)transition;
                int numTransitions = set.getTransitionCount();
                for (int i = 0; i < numTransitions; ++i) {
                    Transition child = set.getTransitionAt(i);
                    FragmentTransitionCompat21.removeTargets(child, views);
                }
                break block3;
            }
            if (FragmentTransitionCompat21.hasSimpleTarget(transition) || (targets = transition.getTargets()) == null || targets.size() != views.size() || !targets.containsAll(views)) break block3;
            for (int i = views.size() - 1; i >= 0; --i) {
                transition.removeTarget(views.get(i));
            }
        }
    }

    public static void addTargets(Object transitionObject, ArrayList<View> views) {
        block3: {
            List targets;
            Transition transition;
            block2: {
                transition = (Transition)transitionObject;
                if (!(transition instanceof TransitionSet)) break block2;
                TransitionSet set = (TransitionSet)transition;
                int numTransitions = set.getTransitionCount();
                for (int i = 0; i < numTransitions; ++i) {
                    Transition child = set.getTransitionAt(i);
                    FragmentTransitionCompat21.addTargets(child, views);
                }
                break block3;
            }
            if (FragmentTransitionCompat21.hasSimpleTarget(transition) || !FragmentTransitionCompat21.isNullOrEmpty(targets = transition.getTargets())) break block3;
            int numViews = views.size();
            for (int i = 0; i < numViews; ++i) {
                transition.addTarget(views.get(i));
            }
        }
    }

    private static boolean hasSimpleTarget(Transition transition) {
        return !FragmentTransitionCompat21.isNullOrEmpty(transition.getTargetIds()) || !FragmentTransitionCompat21.isNullOrEmpty(transition.getTargetNames()) || !FragmentTransitionCompat21.isNullOrEmpty(transition.getTargetTypes());
    }

    private static boolean isNullOrEmpty(List list) {
        return list == null || list.isEmpty();
    }

    public static class EpicenterView {
        public View epicenter;
    }

    public static interface ViewRetriever {
        public View getView();
    }
}

