/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox.multipart;

import com.android.volley.Response;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamProgress
extends OutputStream {
    private final OutputStream outstream;
    private long bytesWritten = 0L;
    private long totalSize = 0L;
    private final Response.ProgressListener progressListener;

    public OutputStreamProgress(OutputStream outstream, Response.ProgressListener progressListener) {
        this.outstream = outstream;
        this.progressListener = progressListener;
    }

    @Override
    public void write(int b) throws IOException {
        this.outstream.write(b);
        if (null != this.progressListener) {
            ++this.bytesWritten;
            this.progressListener.onProgress(this.bytesWritten, this.totalSize);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outstream.write(b);
        if (null != this.progressListener) {
            this.bytesWritten += (long)b.length;
            this.progressListener.onProgress(this.bytesWritten, this.totalSize);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outstream.write(b, off, len);
        if (null != this.progressListener) {
            this.bytesWritten += (long)len;
            this.progressListener.onProgress(this.bytesWritten, this.totalSize);
        }
    }

    @Override
    public void flush() throws IOException {
        this.outstream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outstream.close();
    }
}

