/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox.multipart;

import com.android.volley.misc.MultipartUtils;
import com.android.volley.toolbox.multipart.BasePart;
import com.android.volley.toolbox.multipart.Boundary;
import com.android.volley.toolbox.multipart.UrlEncodingHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FilePart
extends BasePart {
    private final File file;

    public FilePart(String name, File file, String filename, String contentType) {
        if (file == null) {
            throw new IllegalArgumentException("File may not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        this.file = file;
        final String partName = UrlEncodingHelper.encode(name, "US-ASCII");
        final String partFilename = UrlEncodingHelper.encode(filename == null ? file.getName() : filename, "US-ASCII");
        final String partContentType = contentType == null ? "application/octet-stream" : contentType;
        this.headersProvider = new BasePart.IHeadersProvider(){

            @Override
            public String getContentDisposition() {
                return String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"", partName, partFilename);
            }

            @Override
            public String getContentType() {
                return "Content-Type: " + partContentType;
            }

            @Override
            public String getContentTransferEncoding() {
                return "Content-Transfer-Encoding: binary";
            }
        };
    }

    @Override
    public long getContentLength(Boundary boundary) {
        return (long)this.getHeader(boundary).length + this.file.length() + (long)MultipartUtils.CRLF_BYTES.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream out, Boundary boundary) throws IOException {
        out.write(this.getHeader(boundary));
        try (FileInputStream in = new FileInputStream(this.file);){
            int l;
            byte[] tmp = new byte[4096];
            while ((l = ((InputStream)in).read(tmp)) != -1) {
                out.write(tmp, 0, l);
            }
        }
        out.write(MultipartUtils.CRLF_BYTES);
    }
}

