/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.request;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import java.util.HashMap;
import java.util.Map;

public abstract class MultiPartRequest<T>
extends Request<T>
implements Response.ProgressListener {
    private static final String PROTOCOL_CHARSET = "utf-8";
    private Response.Listener<T> mListener;
    private Response.ProgressListener mProgressListener;
    private Map<String, MultiPartParam> mMultipartParams = null;
    private Map<String, String> mFileUploads = null;
    public static final int TIMEOUT_MS = 30000;
    private boolean isFixedStreamingMode;

    public MultiPartRequest(int method, String url, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(method, url, Request.Priority.NORMAL, errorListener, new DefaultRetryPolicy(30000, 0, 1.0f));
        this.mListener = listener;
        this.mMultipartParams = new HashMap<String, MultiPartParam>();
        this.mFileUploads = new HashMap<String, String>();
    }

    public MultiPartRequest<T> addMultipartParam(String name, String contentType, String value) {
        this.mMultipartParams.put(name, new MultiPartParam(contentType, value));
        return this;
    }

    public MultiPartRequest<T> addStringParam(String name, String value) {
        this.mMultipartParams.put(name, new MultiPartParam("text/plain", value));
        return this;
    }

    public MultiPartRequest<T> addFile(String name, String filePath) {
        this.mFileUploads.put(name, filePath);
        return this;
    }

    @Override
    protected abstract Response<T> parseNetworkResponse(NetworkResponse var1);

    @Override
    protected void deliverResponse(T response) {
        if (null != this.mListener) {
            this.mListener.onResponse(response);
        }
    }

    public void setOnProgressListener(Response.ProgressListener listener) {
        this.mProgressListener = listener;
    }

    @Override
    public void onProgress(long transferredBytes, long totalSize) {
        if (null != this.mProgressListener) {
            this.mProgressListener.onProgress(transferredBytes, totalSize);
        }
    }

    public Map<String, MultiPartParam> getMultipartParams() {
        return this.mMultipartParams;
    }

    public Map<String, String> getFilesToUpload() {
        return this.mFileUploads;
    }

    public String getProtocolCharset() {
        return PROTOCOL_CHARSET;
    }

    public boolean isFixedStreamingMode() {
        return this.isFixedStreamingMode;
    }

    public void setFixedStreamingMode(boolean isFixedStreamingMode) {
        this.isFixedStreamingMode = isFixedStreamingMode;
    }

    public static final class MultiPartParam {
        public String contentType;
        public String value;

        public MultiPartParam(String contentType, String value) {
            this.contentType = contentType;
            this.value = value;
        }
    }
}

