/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.request;

import android.text.TextUtils;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.toolbox.HttpHeaderParser;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class DownloadRequest
extends Request<String>
implements Response.ProgressListener {
    private final Response.Listener<String> mListener;
    private final String mDownloadPath;
    private Response.ProgressListener mProgressListener;

    public DownloadRequest(String url, String download_path, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        super(0, url, errorListener);
        this.mDownloadPath = download_path;
        this.mListener = listener;
    }

    public void setOnProgressListener(Response.ProgressListener listener) {
        this.mProgressListener = listener;
    }

    @Override
    protected void deliverResponse(String response) {
        if (null != this.mListener) {
            this.mListener.onResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Response<String> parseNetworkResponse(NetworkResponse response) {
        String parsed = null;
        try {
            byte[] data = response.data;
            FileOutputStream fileOuputStream = new FileOutputStream(this.mDownloadPath);
            fileOuputStream.write(data);
            fileOuputStream.close();
            parsed = this.mDownloadPath;
        }
        catch (UnsupportedEncodingException e) {
            parsed = new String(response.data);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (TextUtils.isEmpty((CharSequence)parsed)) {
                parsed = "";
            }
        }
        return Response.success(parsed, HttpHeaderParser.parseCacheHeaders(response));
    }

    @Override
    public void onProgress(long transferredBytes, long totalSize) {
        if (null != this.mProgressListener) {
            this.mProgressListener.onProgress(transferredBytes, totalSize);
        }
    }
}

