/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.misc;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.StrictMode;
import android.text.TextUtils;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class Utils {
    public static final int ANIMATION_FADE_IN_TIME = 200;
    public static final String SCHEME_FILE = "file";
    public static final String SCHEME_CONTENT = "content";
    public static final String SCHEME_ANDROID_RESOURCE = "android.resource";
    public static final String SCHEME_VIDEO = "video";
    public static final String SCHEME_ASSETS = "asset";
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    private Utils() {
    }

    @TargetApi(value=11)
    public static void enableStrictMode() {
        if (Utils.hasGingerbread()) {
            StrictMode.ThreadPolicy.Builder threadPolicyBuilder = new StrictMode.ThreadPolicy.Builder().detectAll().penaltyLog();
            StrictMode.VmPolicy.Builder vmPolicyBuilder = new StrictMode.VmPolicy.Builder().detectAll().penaltyLog();
            if (Utils.hasHoneycomb()) {
                threadPolicyBuilder.penaltyFlashScreen();
            }
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicyBuilder.build());
            StrictMode.setVmPolicy((StrictMode.VmPolicy)vmPolicyBuilder.build());
        }
    }

    public static boolean hasFroyo() {
        return Build.VERSION.SDK_INT >= 8;
    }

    public static boolean hasGingerbread() {
        return Build.VERSION.SDK_INT >= 9;
    }

    public static boolean hasGingerbreadMR1() {
        return Build.VERSION.SDK_INT >= 10;
    }

    public static boolean hasHoneycomb() {
        return Build.VERSION.SDK_INT >= 11;
    }

    public static boolean hasHoneycombMR1() {
        return Build.VERSION.SDK_INT >= 12;
    }

    public static boolean hasJellyBean() {
        return Build.VERSION.SDK_INT >= 16;
    }

    public static boolean hasJellyBeanMR2() {
        return Build.VERSION.SDK_INT >= 18;
    }

    public static boolean hasKitKat() {
        return Build.VERSION.SDK_INT >= 19;
    }

    @TargetApi(value=9)
    public static long getUsableSpace(File path) {
        if (Utils.hasGingerbread()) {
            return path.getUsableSpace();
        }
        StatFs stats = new StatFs(path.getPath());
        return (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
    }

    public static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = Utils.isExternalMounted() && null != Utils.getExternalCacheDir(context) ? Utils.getExternalCacheDir(context).getPath() : context.getCacheDir().getPath();
        Log.i((String)"Cache dir", (String)(cachePath + File.separator + uniqueName));
        return new File(cachePath + File.separator + uniqueName);
    }

    private static File getExternalCacheDir(Context context) {
        return context.getExternalCacheDir();
    }

    @SuppressLint(value={"NewApi"})
    private static boolean isExternalMounted() {
        if (Utils.hasGingerbread()) {
            return "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable();
        }
        return "mounted".equals(Environment.getExternalStorageState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(Reader reader) throws IOException {
        try {
            int count;
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            while ((count = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, count);
            }
            String string2 = writer.toString();
            return string2;
        }
        finally {
            reader.close();
        }
    }

    public static void deleteContents(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("not a readable directory: " + dir);
        }
        for (File file : files) {
            if (file.isDirectory()) {
                Utils.deleteContents(file);
            }
            if (file.delete()) continue;
            throw new IOException("failed to delete file: " + file);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isSpecialType(String url) {
        boolean isSpecial = url.startsWith(SCHEME_FILE) || url.startsWith(SCHEME_VIDEO) || url.startsWith(SCHEME_CONTENT) || url.startsWith(SCHEME_ANDROID_RESOURCE);
        return isSpecial;
    }

    public static String getSchemeBaseUrl(String type, String url) {
        return type + "://" + url;
    }

    public static String getSchemeBaseUrl(String type, int id) {
        return type + "://" + id;
    }

    public static String getHeader(HttpResponse response, String key) {
        Header header = response.getFirstHeader(key);
        return header == null ? null : header.getValue();
    }

    public static boolean isSupportRange(HttpResponse response) {
        if (TextUtils.equals((CharSequence)Utils.getHeader(response, "Accept-Ranges"), (CharSequence)"bytes")) {
            return true;
        }
        String value = Utils.getHeader(response, "Content-Range");
        return value != null && value.startsWith("bytes");
    }

    public static boolean isGzipContent(HttpResponse response) {
        return TextUtils.equals((CharSequence)Utils.getHeader(response, "Content-Encoding"), (CharSequence)"gzip");
    }

    public static interface HorizontallyScrollable {
        public boolean interceptMoveLeft(float var1, float var2);

        public boolean interceptMoveRight(float var1, float var2);
    }
}

