/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.misc;

import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.util.Base64;
import android.util.Log;
import com.android.volley.misc.Exif;
import java.io.ByteArrayInputStream;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;

public class ImageUtils {
    private static final String TAG = "ImageUtils";
    private static final long MIN_NORMAL_CLASS = 32L;
    private static final long MIN_SMALL_CLASS = 24L;
    private static final String BASE64_URI_PREFIX = "base64,";
    private static final Pattern BASE64_IMAGE_URI_PATTERN = Pattern.compile("^(?:.*;)?base64,.*");

    public static int findBestSampleSize(int actualWidth, int actualHeight, int desiredWidth, int desiredHeight) {
        double wr = (double)actualWidth / (double)desiredWidth;
        double hr = (double)actualHeight / (double)desiredHeight;
        double ratio = Math.min(wr, hr);
        float n = 1.0f;
        while ((double)(n * 2.0f) <= ratio) {
            n *= 2.0f;
        }
        return (int)n;
    }

    public static Bitmap decodeSampledBitmapFromDescriptor(FileDescriptor fileDescriptor, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtils.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
    }

    public static Bitmap decodeSampledBitmapFromDescriptor(FileDescriptor fileDescriptor) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize > reqHeight && halfWidth / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
            long totalReqPixelsCap = reqWidth * reqHeight * 2;
            for (long totalPixels = (long)(width * height / inSampleSize); totalPixels > totalReqPixelsCap; totalPixels /= 2L) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    public static boolean isImageMimeType(String mimeType) {
        return mimeType != null && mimeType.startsWith("image/");
    }

    public static Bitmap decodeStream(ContentResolver resolver, Uri uri, int maxSize) {
        Bitmap result = null;
        InputStreamFactory factory = ImageUtils.createInputStreamFactory(resolver, uri);
        try {
            Point bounds = ImageUtils.getImageBounds(factory);
            if (bounds == null) {
                return result;
            }
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inSampleSize = Math.max(bounds.x / maxSize, bounds.y / maxSize);
            result = ImageUtils.decodeStream(factory, null, opts);
            return result;
        }
        catch (FileNotFoundException exception) {
        }
        catch (IOException exception) {
        }
        catch (IllegalArgumentException exception) {
        }
        catch (SecurityException exception) {
            // empty catch block
        }
        return result;
    }

    public static Bitmap decodeStream(ContentResolver resolver, Uri uri, BitmapFactory.Options opts) {
        Bitmap result = null;
        InputStreamFactory factory = ImageUtils.createInputStreamFactory(resolver, uri);
        try {
            result = ImageUtils.decodeStream(factory, null, opts);
            return result;
        }
        catch (FileNotFoundException exception) {
        }
        catch (IllegalArgumentException exception) {
        }
        catch (SecurityException exception) {
            // empty catch block
        }
        return result;
    }

    public static Bitmap decodeStream(InputStream is, Rect outPadding, BitmapFactory.Options opts) {
        try {
            return BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)opts);
        }
        catch (OutOfMemoryError oome) {
            Log.e((String)TAG, (String)"ImageUtils#decodeStream(InputStream, Rect, Options) threw an OOME", (Throwable)oome);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeStream(InputStreamFactory factory, Rect outPadding, BitmapFactory.Options opts) throws FileNotFoundException {
        Bitmap bitmap;
        InputStream is = null;
        try {
            is = factory.createInputStream();
            int orientation = Exif.getOrientation(is, -1L);
            is.close();
            is = factory.createInputStream();
            Bitmap originalBitmap = BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)opts);
            if (is != null && originalBitmap == null && !opts.inJustDecodeBounds) {
                Log.w((String)TAG, (String)"ImageUtils#decodeStream(InputStream, Rect, Options): Image bytes cannot be decoded into a Bitmap");
                throw new UnsupportedOperationException("Image bytes cannot be decoded into a Bitmap.");
            }
            if (originalBitmap != null && orientation != 0) {
                Matrix matrix = new Matrix();
                matrix.postRotate((float)orientation);
                Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)originalBitmap, (int)0, (int)0, (int)originalBitmap.getWidth(), (int)originalBitmap.getHeight(), (Matrix)matrix, (boolean)true);
                return bitmap2;
            }
            Bitmap matrix = originalBitmap;
            return matrix;
        }
        catch (OutOfMemoryError oome) {
            Log.e((String)TAG, (String)"ImageUtils#decodeStream(InputStream, Rect, Options) threw an OOME", (Throwable)oome);
            bitmap = null;
            return bitmap;
        }
        catch (IOException ioe) {
            Log.e((String)TAG, (String)"ImageUtils#decodeStream(InputStream, Rect, Options) threw an IOE", (Throwable)ioe);
            bitmap = null;
            return bitmap;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static Point getImageBounds(InputStreamFactory factory) throws IOException {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        ImageUtils.decodeStream(factory, null, opts);
        return new Point(opts.outWidth, opts.outHeight);
    }

    public static InputStreamFactory createInputStreamFactory(ContentResolver resolver, Uri uri) {
        String scheme = uri.getScheme();
        if ("data".equals(scheme)) {
            return new DataInputStreamFactory(resolver, uri);
        }
        return new BaseInputStreamFactory(resolver, uri);
    }

    private static class DataInputStreamFactory
    extends BaseInputStreamFactory {
        private byte[] mData;

        public DataInputStreamFactory(ContentResolver resolver, Uri uri) {
            super(resolver, uri);
        }

        @Override
        public InputStream createInputStream() throws FileNotFoundException {
            if (this.mData == null) {
                this.mData = this.parseDataUri(this.mUri);
                if (this.mData == null) {
                    return super.createInputStream();
                }
            }
            return new ByteArrayInputStream(this.mData);
        }

        private byte[] parseDataUri(Uri uri) {
            String ssp = uri.getSchemeSpecificPart();
            try {
                if (ssp.startsWith(ImageUtils.BASE64_URI_PREFIX)) {
                    String base64 = ssp.substring(ImageUtils.BASE64_URI_PREFIX.length());
                    return Base64.decode((String)base64, (int)8);
                }
                if (BASE64_IMAGE_URI_PATTERN.matcher(ssp).matches()) {
                    String base64 = ssp.substring(ssp.indexOf(ImageUtils.BASE64_URI_PREFIX) + ImageUtils.BASE64_URI_PREFIX.length());
                    return Base64.decode((String)base64, (int)0);
                }
                return null;
            }
            catch (IllegalArgumentException ex) {
                Log.e((String)ImageUtils.TAG, (String)("Mailformed data URI: " + ex));
                return null;
            }
        }
    }

    private static class BaseInputStreamFactory
    implements InputStreamFactory {
        protected final ContentResolver mResolver;
        protected final Uri mUri;

        public BaseInputStreamFactory(ContentResolver resolver, Uri uri) {
            this.mResolver = resolver;
            this.mUri = uri;
        }

        @Override
        public InputStream createInputStream() throws FileNotFoundException {
            return this.mResolver.openInputStream(this.mUri);
        }
    }

    public static interface InputStreamFactory {
        public InputStream createInputStream() throws FileNotFoundException;
    }
}

