/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.cache.plus;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.os.Bundle;
import android.os.StatFs;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.util.LruCache;
import com.android.volley.VolleyLog;
import com.android.volley.cache.DiskLruBasedCache;
import com.android.volley.cache.plus.ImageCache;
import com.android.volley.misc.Utils;
import com.android.volley.ui.RecyclingBitmapDrawable;
import java.io.File;

public class BitmapImageCache
implements ImageCache {
    private static final String TAG = "BitmapImageCache";
    private static final float DEFAULT_MEM_CACHE_PERCENT = 0.25f;
    private LruCache<String, BitmapDrawable> mMemoryCache;

    private BitmapImageCache(int memCacheSize) {
        this.init(memCacheSize);
    }

    public static BitmapImageCache getInstance(FragmentManager fragmentManager, String fragmentTag, int memCacheSize) {
        BitmapImageCache bitmapImageCache = null;
        RetainFragment mRetainFragment = null;
        if (fragmentManager != null) {
            mRetainFragment = BitmapImageCache.getRetainFragment(fragmentManager, fragmentTag);
            bitmapImageCache = (BitmapImageCache)mRetainFragment.getObject();
        }
        if (bitmapImageCache == null) {
            bitmapImageCache = new BitmapImageCache(memCacheSize);
            if (mRetainFragment != null) {
                mRetainFragment.setObject(bitmapImageCache);
            }
        }
        return bitmapImageCache;
    }

    public static BitmapImageCache getInstance(FragmentManager fragmentManager, int memCacheSize) {
        return BitmapImageCache.getInstance(fragmentManager, TAG, memCacheSize);
    }

    public static BitmapImageCache getInstance(FragmentManager fragmentManager, float memCachePercent) {
        return BitmapImageCache.getInstance(fragmentManager, BitmapImageCache.calculateMemCacheSize(memCachePercent));
    }

    public static BitmapImageCache getInstance(FragmentManager fragmentManger) {
        return BitmapImageCache.getInstance(fragmentManger, 0.25f);
    }

    public static BitmapImageCache getInstance(FragmentManager fragmentManger, DiskLruBasedCache.ImageCacheParams imageCacheParams) {
        return BitmapImageCache.getInstance(fragmentManger, imageCacheParams != null ? imageCacheParams.memCacheSize : BitmapImageCache.calculateMemCacheSize(0.25f));
    }

    private void init(int memCacheSize) {
        VolleyLog.d(TAG, "Memory cache created (size = " + memCacheSize + "KB)");
        this.mMemoryCache = new LruCache<String, BitmapDrawable>(memCacheSize){

            protected int sizeOf(String key, BitmapDrawable bitmap) {
                int bitmapSize = BitmapImageCache.getBitmapSize(bitmap) / 1024;
                return bitmapSize == 0 ? 1 : bitmapSize;
            }

            protected void entryRemoved(boolean evicted, String key, BitmapDrawable oldValue, BitmapDrawable newValue) {
                super.entryRemoved(evicted, (Object)key, (Object)oldValue, (Object)newValue);
                VolleyLog.d(BitmapImageCache.TAG, "Memory cache entry removed - " + key);
                if (RecyclingBitmapDrawable.class.isInstance(oldValue)) {
                    ((RecyclingBitmapDrawable)oldValue).setIsCached(false);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBitmapToCache(String data, BitmapDrawable bitmap) {
        if (data == null || bitmap == null) {
            return;
        }
        LruCache<String, BitmapDrawable> lruCache = this.mMemoryCache;
        synchronized (lruCache) {
            VolleyLog.d(TAG, "Memory cache put - " + data);
            if (RecyclingBitmapDrawable.class.isInstance(bitmap)) {
                ((RecyclingBitmapDrawable)bitmap).setIsCached(true);
            }
            this.mMemoryCache.put((Object)data, (Object)bitmap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitmapDrawable getBitmapFromMemCache(String data) {
        if (data != null) {
            LruCache<String, BitmapDrawable> lruCache = this.mMemoryCache;
            synchronized (lruCache) {
                BitmapDrawable memBitmap = (BitmapDrawable)this.mMemoryCache.get((Object)data);
                if (memBitmap != null) {
                    VolleyLog.d(TAG, "Memory cache hit - " + data);
                    return memBitmap;
                }
            }
            VolleyLog.d(TAG, "Memory cache miss - " + data);
        }
        return null;
    }

    public void clearCache() {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.evictAll();
            VolleyLog.d(TAG, "Memory cache cleared");
        }
    }

    public static int calculateMemCacheSize(float percent) {
        if (percent < 0.05f || percent > 0.8f) {
            throw new IllegalArgumentException("setMemCacheSizePercent - percent must be between 0.05 and 0.8 (inclusive)");
        }
        return Math.round(percent * (float)Runtime.getRuntime().maxMemory() / 1024.0f);
    }

    @TargetApi(value=19)
    public static int getBitmapSize(Bitmap bitmap) {
        if (Utils.hasKitKat()) {
            return bitmap.getAllocationByteCount();
        }
        if (Utils.hasHoneycombMR1()) {
            return bitmap.getByteCount();
        }
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    public static int getBitmapSize(BitmapDrawable value) {
        Bitmap bitmap = value.getBitmap();
        return BitmapImageCache.getBitmapSize(bitmap);
    }

    @TargetApi(value=9)
    public static long getUsableSpace(File path) {
        if (Utils.hasGingerbread()) {
            return path.getUsableSpace();
        }
        StatFs stats = new StatFs(path.getPath());
        return (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
    }

    private static RetainFragment getRetainFragment(FragmentManager fm, String fragmentTag) {
        RetainFragment mRetainFragment = (RetainFragment)fm.findFragmentByTag(fragmentTag);
        if (mRetainFragment == null) {
            mRetainFragment = new RetainFragment();
            fm.beginTransaction().add((Fragment)mRetainFragment, fragmentTag).commitAllowingStateLoss();
        }
        return mRetainFragment;
    }

    @Override
    public BitmapDrawable getBitmap(String key) {
        return this.getBitmapFromMemCache(key);
    }

    @Override
    public void putBitmap(String key, BitmapDrawable bitmap) {
        this.addBitmapToCache(key, bitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateBitmap(String url) {
        if (url == null) {
            return;
        }
        LruCache<String, BitmapDrawable> lruCache = this.mMemoryCache;
        synchronized (lruCache) {
            VolleyLog.d(TAG, "Memory cache remove - " + url);
            this.mMemoryCache.remove((Object)url);
        }
    }

    @Override
    public void clear() {
        this.clearCache();
    }

    public static class RetainFragment
    extends Fragment {
        private Object mObject;

        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.setRetainInstance(true);
        }

        public void setObject(Object object) {
            this.mObject = object;
        }

        public Object getObject() {
            return this.mObject;
        }
    }
}

