/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.cache;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.android.volley.misc.DiskLruCache;
import com.android.volley.toolbox.ImageCache;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DiskLruImageCache
implements ImageCache {
    private DiskLruCache mDiskCache;
    private Bitmap.CompressFormat mCompressFormat = Bitmap.CompressFormat.JPEG;
    private static int IO_BUFFER_SIZE = 8192;
    private int mCompressQuality = 70;
    private static final int APP_VERSION = 1;
    private static final int VALUE_COUNT = 1;

    public DiskLruImageCache(Context context, String uniqueName, int diskCacheSize, Bitmap.CompressFormat compressFormat, int quality) {
        try {
            File diskCacheDir = this.getDiskCacheDir(context, uniqueName);
            this.mDiskCache = DiskLruCache.open(diskCacheDir, 1, 1, diskCacheSize);
            this.mCompressFormat = compressFormat;
            this.mCompressQuality = quality;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeBitmapToFile(Bitmap bitmap, DiskLruCache.Editor editor) throws IOException, FileNotFoundException {
        try (OutputStream out = null;){
            out = new BufferedOutputStream(editor.newOutputStream(0), IO_BUFFER_SIZE);
            boolean bl = bitmap.compress(this.mCompressFormat, this.mCompressQuality, out);
            return bl;
        }
    }

    private File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = context.getCacheDir().getPath();
        return new File(cachePath + File.separator + uniqueName);
    }

    @Override
    public void putBitmap(String key, Bitmap data) {
        DiskLruCache.Editor editor = null;
        try {
            editor = this.mDiskCache.edit(key);
            if (editor == null) {
                return;
            }
            if (this.writeBitmapToFile(data, editor)) {
                this.mDiskCache.flush();
                editor.commit();
            } else {
                editor.abort();
            }
        }
        catch (IOException e) {
            try {
                if (editor != null) {
                    editor.abort();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap getBitmap(String key) {
        Bitmap bitmap = null;
        try (DiskLruCache.Snapshot snapshot = null;){
            snapshot = this.mDiskCache.get(key);
            if (snapshot == null) {
                Bitmap bitmap2 = null;
                return bitmap2;
            }
            InputStream in = snapshot.getInputStream(0);
            if (in != null) {
                BufferedInputStream buffIn = new BufferedInputStream(in, IO_BUFFER_SIZE);
                bitmap = BitmapFactory.decodeStream((InputStream)buffIn);
            }
        }
        return bitmap;
    }

    @Override
    public void invalidateBitmap(String url) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        boolean contained = false;
        try (DiskLruCache.Snapshot snapshot = null;){
            snapshot = this.mDiskCache.get(key);
            contained = snapshot != null;
        }
        return contained;
    }

    public void clearCache() {
        try {
            this.mDiskCache.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getCacheFolder() {
        return this.mDiskCache.getDirectory();
    }

    @Override
    public void clear() {
        this.clearCache();
    }
}

