/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import android.annotation.TargetApi;
import android.net.TrafficStats;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.android.volley.Cache;
import com.android.volley.ExecutorDelivery;
import com.android.volley.Network;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.ResponseDelivery;
import com.android.volley.VolleyLog;
import com.android.volley.error.VolleyError;

public class RequestTickle {
    private Request<?> mRequest;
    private final Cache mCache;
    private final Network mNetwork;
    private final ResponseDelivery mDelivery;
    private Response<?> response;
    private VolleyError error;

    public RequestTickle(Cache cache, Network network, ResponseDelivery delivery) {
        this.mCache = cache;
        this.mNetwork = network;
        this.mDelivery = delivery;
    }

    public RequestTickle(Cache cache, Network network) {
        this(cache, network, new ExecutorDelivery(new Handler(Looper.getMainLooper())));
    }

    public <T> Request<T> add(Request<T> request) {
        this.mRequest = request;
        return request;
    }

    public void cancel() {
        if (null == this.mRequest) {
            return;
        }
        this.mRequest.cancel();
    }

    public Cache getCache() {
        return this.mCache;
    }

    @TargetApi(value=14)
    public NetworkResponse start() {
        if (null == this.mRequest) {
            return null;
        }
        NetworkResponse networkResponse = null;
        long startTimeMs = SystemClock.elapsedRealtime();
        try {
            this.mRequest.addMarker("network-queue-take");
            if (this.mRequest.isCanceled()) {
                this.mRequest.finish("network-discard-cancelled");
                return null;
            }
            if (Build.VERSION.SDK_INT >= 14) {
                TrafficStats.setThreadStatsTag((int)this.mRequest.getTrafficStatsTag());
            }
            networkResponse = this.mNetwork.performRequest(this.mRequest);
            if (networkResponse.notModified && this.mRequest.hasHadResponseDelivered()) {
                this.mRequest.finish("not-modified");
                return networkResponse;
            }
            this.response = this.mRequest.parseNetworkResponse(networkResponse);
            this.mRequest.addMarker("network-parse-complete");
            if (this.mCache != null && this.mRequest.shouldCache() && this.response.cacheEntry != null) {
                this.mCache.put(this.mRequest.getCacheKey(), this.response.cacheEntry);
                this.mRequest.addMarker("network-cache-written");
            }
            this.mRequest.markDelivered();
            this.mDelivery.postResponse(this.mRequest, this.response);
        }
        catch (VolleyError volleyError) {
            networkResponse = volleyError.networkResponse;
            volleyError.setNetworkTimeMs(SystemClock.elapsedRealtime() - startTimeMs);
            this.parseAndDeliverNetworkError(this.mRequest, volleyError);
        }
        catch (Exception e) {
            VolleyLog.e(e, "Unhandled exception %s", e.toString());
            VolleyError volleyError = new VolleyError(e);
            volleyError.setNetworkTimeMs(SystemClock.elapsedRealtime() - startTimeMs);
            this.mDelivery.postError(this.mRequest, volleyError);
        }
        if (null == networkResponse) {
            networkResponse = new NetworkResponse(0, null, null, false);
        }
        return networkResponse;
    }

    public Response<?> getResponse() {
        return this.response;
    }

    public VolleyError getError() {
        return this.error;
    }

    private void parseAndDeliverNetworkError(Request<?> request, VolleyError volleyError) {
        this.error = request.parseNetworkError(volleyError);
        this.mDelivery.postError(request, this.error);
    }
}

