/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content.res;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.res.ResourcesCompatApi21;
import android.support.v4.content.res.ResourcesCompatApi23;
import android.support.v4.content.res.ResourcesCompatIcsMr1;

public final class ResourcesCompat {
    @Nullable
    public static Drawable getDrawable(@NonNull Resources res, @DrawableRes int id2, @Nullable Resources.Theme theme) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            return ResourcesCompatApi21.getDrawable((Resources)res, (int)id2, (Resources.Theme)theme);
        }
        return res.getDrawable(id2);
    }

    @Nullable
    public static Drawable getDrawableForDensity(@NonNull Resources res, @DrawableRes int id2, int density, @Nullable Resources.Theme theme) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            return ResourcesCompatApi21.getDrawableForDensity((Resources)res, (int)id2, (int)density, (Resources.Theme)theme);
        }
        if (Build.VERSION.SDK_INT >= 15) {
            return ResourcesCompatIcsMr1.getDrawableForDensity((Resources)res, (int)id2, (int)density);
        }
        return res.getDrawable(id2);
    }

    @ColorInt
    public static int getColor(@NonNull Resources res, @ColorRes int id2, @Nullable Resources.Theme theme) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 23) {
            return ResourcesCompatApi23.getColor((Resources)res, (int)id2, (Resources.Theme)theme);
        }
        return res.getColor(id2);
    }

    @Nullable
    public static ColorStateList getColorStateList(@NonNull Resources res, @ColorRes int id2, @Nullable Resources.Theme theme) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 23) {
            return ResourcesCompatApi23.getColorStateList((Resources)res, (int)id2, (Resources.Theme)theme);
        }
        return res.getColorStateList(id2);
    }

    private ResourcesCompat() {
    }
}

