package com.fablabesan.apps.appegg;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.Intent;
import android.util.Log;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;

public class MainActivity extends AppCompatActivity {

    ListView deviceList ;
    boolean flag = false;
    private BluetoothAdapter myBluetooth = null;
    BluetoothSocket btSocket = null;

    private Set<BluetoothDevice> pairedDevices;
    public static String EXTRA_ADDRESS = "device_address";

    // Key names received from the BluetoothChatService Handler
    public static final String DEVICE_NAME = "HC-05";
    public static final String TOAST = "1234";

            // Intent request codes
    private static final int REQUEST_CONNECT_DEVICE = 1;
    private static final int REQUEST_ENABLE_BT = 2;
    static final UUID myUUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        deviceList = (ListView)findViewById(R.id.listview);
        myBluetooth = BluetoothAdapter.getDefaultAdapter();
        //if the adapter is null, then bluetooth is not supported
        if (myBluetooth == null)
        {
            Toast.makeText(this,"Bluetooth is not available",Toast.LENGTH_LONG).show();
            finish();
            return;
        }
        if (!myBluetooth.isEnabled()) {
            Intent enableBtIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
            startActivityForResult(enableBtIntent, REQUEST_ENABLE_BT);
        }
        pairedDevicesList();
    }


    private void pairedDevicesList(){
        pairedDevices = myBluetooth.getBondedDevices();
        ArrayList<String> list = new ArrayList();
        if (pairedDevices.size()>0){
            for (BluetoothDevice bt : pairedDevices)
            {
                list.add(bt.getName()+"\n"+bt.getAddress()); //get the devices name and the address
                Log.d("blue",bt.getName()+" "+bt.getAddress());
            }
        }
        else{
            Toast.makeText(getApplicationContext(),"No Paired Bluetooth devices found", Toast.LENGTH_LONG).show();;
        }

        final ArrayAdapter adapter = new ArrayAdapter(this, android.R.layout.simple_list_item_1, list );
        if(deviceList != null)
        {
            deviceList.setAdapter(adapter);
        }
        else
        {
            Log.d("device list", "nulo");
        }

        AdapterView.OnItemClickListener myListClickListener = new AdapterView.OnItemClickListener()
        {
            public void onItemClick (AdapterView av, View v, int arg2, long arg3)
            {
                // Get the device MAC address, the last 17 chars in the View
                String info = ((TextView) v).getText().toString();
                String address = info.substring(info.length() - 17);
                Log.d("adress",address);
                // Make an intent to start next activity.
                Intent i = new Intent(MainActivity.this, MotorActivity.class);
                //Change the activity.
                i.putExtra(EXTRA_ADDRESS, address); //this will be received at ledControl (class) Activity
                startActivity(i);
            }
        };

        deviceList.setOnItemClickListener(myListClickListener); //method called when the device from the list is called

    }


}
