#include <Wire.h>
#include <Servo.h>

Servo myservo;  // create servo object to control a servo


void setup() {
  Wire.begin();        // join i2c bus (address optional for master)
  Serial.begin(9600);  // start serial for output

  myservo.attach(7);
}

void loop() {
  Wire.requestFrom(8, 1);    // request 6 bytes from slave device #8

  while (Wire.available()) { // slave may send less than requested
    char c = Wire.read(); // receive a byte as character
    Serial.print(int(c));         // print the character
    myservo.write(c);  
    
  }
  Serial.println("");
  delay(1500);
}
