#include <CapacitiveSensor.h>
#include <Adafruit_NeoPixel.h>
#include <SoftwareSerial.h>
#ifdef __AVR__
#include <avr/power.h>
#endif

#define PIN  2

#define NUMPIXELS      3

CapacitiveSensor   cs_4_2 = CapacitiveSensor(0, 1);       // 10M resistor between pins 4 & 2, pin 2 is sensor pin, add a wire and or foil if desired

Adafruit_NeoPixel pixels = Adafruit_NeoPixel(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);
SoftwareSerial mySerial(3, 4); // RX, TX

int delayval = 50;
int clic = 0;


void setup() {

  // This is for Trinket 5V 16MHz, you can remove these three lines if you are not using a Trinket
#if defined (__AVR_ATtiny85__)
  if (F_CPU == 8000000) clock_prescale_set(clock_div_1);
#endif

  mySerial.begin(4800);
  mySerial.println("Hello, world?");
  // End of trinket special code
  cs_4_2.set_CS_AutocaL_Millis(0xFFFFFFFF);     // turn off autocalibrate on channel 1 - just as an example
  //Serial.begin(9600);
  pixels.begin(); // This initializes the NeoPixel library.
}

void loop() {
  long total =  cs_4_2.capacitiveSensor(30);

  if (total < 100) {

  }
  else {
    if (clic == 0) {
      clic = 255;
    } else {
      clic = 0;
    }
    for (int i = 0; i < NUMPIXELS; i++) {

      pixels.setPixelColor(i, pixels.Color(clic, clic, clic)); // Moderately bright green color.
      pixels.show(); // This sends the updated pixel color to the hardware.
      delay(delayval);
    }
    delay(1000);

  }
  mySerial.write(total);
  mySerial.write("hola");

  //Serial.println(total);                  // print sensor output 1

}
