width = 92;     // Outside with
lenght = 240;   // Outside lenght
tickness = 2;   // Wall tickness

radius = width/2;
delta = tickness*2;
border = 12;

hole = 8.2;   // Inside diameter
tube = 12;  // Tube inside lenght

$fn = 60;

difference(){
    union(){
        // Top
//        translate([0,0,radius/2]){
//            cube([lenght,width,radius],true);
//        }
        // Bottom
        rotate([0,90,0]){
            cylinder(h = lenght, r = radius, center = true);
        }
        // Border
        translate([0,0,(tickness/2)]){
            cube([lenght,width+(border*2),tickness],true);
        }
        // Tubes
        translate([(lenght/2)-(hole/2)-tickness,0,-radius-tickness]){
           cylinder(h = tube, r = (hole/2)+tickness, center = true);
        }
        translate([-(lenght/2)+(hole/2)+tickness,0,-radius-tickness]){
           cylinder(h = tube, r = (hole/2)+tickness, center = true);
        }
    }
    union(){
        // Top
        translate([0,0,(radius/2)+tickness]){
            cube([lenght+delta,width+delta,radius],true);
        }
        // Bottom
        rotate([0,90,0]){
            cylinder(h = lenght-delta, r = radius-tickness, center = true);
        }
        // Holes
        translate([(lenght/2)-(hole/2)-tickness,0,-radius-delta]){
            cylinder(h = tube*2, r = hole/2, center = true);            
        }
        translate([-(lenght/2)+(hole/2)+tickness,0,-radius-delta]){
           cylinder(h = tube*2, r = hole/2, center = true);  
        }
        translate([0,radius-hole,-hole/2]){
            rotate([0,90,0]){
                cylinder(h = lenght+delta, r = hole/2, center = true);
            }
        }
        translate([0,-radius+hole,-hole/2]){
            rotate([0,90,0]){
                cylinder(h = lenght+delta, r = hole/2, center = true);
            }
        }
    }
}

