radius=15;
angle=30;
thick=2.8;
kerf=0.2;
lenght=60;
width=(thick*3)+kerf;

module nucleus(qn){
	for(i=[0:1]){
		translate([0,-(radius+kerf)*2*i,0]) {
			for(i=[0:qn-1]){
				translate([(radius+kerf)*2*i,0,0]) {
					difference() {
						circle(r=(radius+kerf));
						translate([radius,0,0]) {
							square([radius*2,(thick-kerf)], true);
						}
						for(i=[angle:angle:160]){
							rotate([0,0,i]){
								translate([radius,0,0]) {
									square([thick*2,(thick-kerf)], true);
									}
							}
						}
						for(i=[(180+angle):angle:330]){
							rotate([0,0,i]){
								translate([radius,0,0]) {
									square([thick*2,(thick-kerf)], true);
									}
							}
						}
					}
				}
			}
		}
	}
}


module bond(qb){
translate([-radius,radius+(kerf*2),0]){
	for(i=[0:qb-1]){
		translate([(width*i)+i,0,0]) {
			difference() {
				square([width,(lenght+kerf)], false);
				translate([thick*1.5,(lenght),0]){
					square([thick,(thick*2)-kerf], true);
				}
				translate([thick*1.5,0,0]){
					square([thick,(thick*2)-kerf], true);
				}
			}
		}
	}
}
}

nucleus(16);
bond(20);