#include "SdsDustSensor.h"
#include "Servo.h" 

int rxPin = 10; //orange
int txPin = 9; //parler au senseur

const int led1 = 2;
const int led2 = 3;
const int led3 = 4;

// Declare the Servo pin 
int servo1Pin = 5; 
int servo2Pin = 6;

// Create a servo object 
Servo Servo1; //Sternum
Servo Servo2; //Wing

SdsDustSensor sds(rxPin, txPin);

void setup() {
  Serial.begin(9600);
  sds.begin();

 pinMode(led1, OUTPUT);
 pinMode(led2, OUTPUT);
 pinMode(led3, OUTPUT);

    // We need to attach the servo to the used pin number 
   Servo1.attach(servo1Pin);
   Servo2.attach(servo2Pin); 
 
  Serial.println(sds.queryFirmwareVersion().toString()); // prints firmware version
  Serial.println(sds.setActiveReportingMode().toString()); // ensures sensor is in 'active' reporting mode
  Serial.println(sds.setContinuousWorkingPeriod().toString()); // ensures sensor has continuous working period - default but not recommended
}

void loop() {
  PmResult pm = sds.readPm();
  if (pm.isOk()) {
    Serial.print("PM2.5 = ");
    Serial.print(pm.pm25);
    Serial.print(", PM10 = ");
    Serial.println(pm.pm10);

    digitalWrite(led1, HIGH);   // turn the LED on (HIGH is the voltage level)
    delay(1000);
    digitalWrite(led1,LOW);

    //bird fly
   // Make servo go to 15 degrees-Sternum 
   
   Servo1.write(90); //Unfolded wing
   delay(1000);
   Servo2.write(180); //Open wing latteral
   delay(3000); 
   
   Servo1.write(0); //Fly no.1 - wings down
   delay(1000);
   Servo1.write(180); //Fly no.1 - wings up
   delay(1000);
   
   Servo1.write(0); //Fly no.2 - wings down
   delay(1000);
   Servo1.write(180); //Fly no.2 - wings up
   delay(3000); 

   Servo1.write(90); //Folded wing
   delay(1000);
   Servo2.write(0); //Close wing latteral
   delay(5000);

    // if you want to just print the measured values, you can use toString() method as well
    Serial.println(pm.toString());
    
  } else {
    // notice that loop delay is set to 0.5s and some reads are not available
    Serial.println("Could not read values from sensor, reason: ");
    Serial.println(pm.statusToString());
    digitalWrite(led2, HIGH);   // turn the LED on (HIGH is the voltage level)
 delay(1000);
    digitalWrite(led2,LOW);
  }

  delay(100);
}
