/*
  modified by Victor Levy on the 15/06/2018 Fabacademy 2018
  inspired by the work of Muzi on Hackaday 
  https://hackaday.io/project/26309-how-to-make-an-office-thermometer
   */

#include <NewTone.h>
#include <OneWire.h>
#include <TimeLib.h>
#include <TimeAlarms.h>
#include <LCD_ST7032.h>
#include "pitches.h"

#define lcd_rst 3
#define lcd_led 2
#define speaker 4
#define relay 5
#define thermo 7
#define up 8
#define down 9
#define center 10

OneWire ds(thermo);  // on digital pin 7
LCD_ST7032 lcd;

String inString = "";
boolean arret = true;
int reglage = 0;
int consigne = 50;
int heure = 0;
int minutes = 0;


// notes in the melody:
int melody[] = { NOTE_C4, NOTE_G3, NOTE_G3, NOTE_A3, NOTE_G3, 0, NOTE_B3, NOTE_C4 };

// note durations: 4 = quarter note, 8 = eighth note, etc.:
int noteDurations[] = { 4, 8, 8, 4, 4, 4, 4, 4 };

void setup() {
  pinMode(up, INPUT_PULLUP);
  pinMode(down, INPUT_PULLUP);
  pinMode(center, INPUT_PULLUP);
  pinMode (relay, OUTPUT);
  pinMode(lcd_rst, OUTPUT);
   pinMode(lcd_led, OUTPUT);


  digitalWrite(lcd_rst, LOW);
  delay(50);
  digitalWrite(lcd_rst, HIGH);
digitalWrite(lcd_led, HIGH);
lcd.begin();
  lcd.setcontrast(25);
  lcd.setCursor(0, 1);
  lcd.write('T');
  lcd.print(consigne);
  lcd.write(' ');
  lcd.write(0xdf);
  lcd.write('C');
  lcd.setCursor(0, 0);
  lcd.write(0b111110);
  lcd.setCursor(1, 1);
  lcd.print("H");
   Alarm.timerRepeat(1, Repeats); // décompte toute les minutes
}

void loop() {

  Alarm.delay(10);

if (arret==true) // si la variable arret = 1
  {
    lcd.setCursor(0, 2);
    lcd.print(consigne);
    lcd.write(' ');
    lcd.setCursor(1, 2);
    lcd.print (zero(heure));
    lcd.write (':');
    lcd.print (zero(minutes));

    if ( not digitalRead (up)) // on a appuyé sur +
    {
      switch (reglage) {
        case 0: consigne ++;
          break;
        case 1: heure ++;
          break;
        case 2: minutes += 1;
          if (minutes > 60) {
            minutes = 60;

          }
          break;
      }
      Alarm.delay(200);
    }

    if ( not digitalRead (center)) // on a appuyé au centre
    {
      reglage ++;

      if (reglage <= 2) {
        switch (reglage) {
          case 0: lcd.setCursor(0, 0);
            lcd.write(0b111110);
            lcd.setCursor(1, 7);
            lcd.write(' ');
            break;
          case 1: lcd.setCursor(1, 0);
            lcd.write(0b111110);
            lcd.setCursor(0, 0);
            lcd.write(' ');
            break;
          case 2: lcd.setCursor(1, 7);
            lcd.write(0b111100);
            lcd.setCursor(1, 0);
            lcd.write(' ');
            break;
        }
      }
      else {
        arret = false;
      setTime(0, 0, 0, 1, 1, 1); // date 0 h 0 min 59 sec 1 janvier 2001
    // Repeats(); // c'est la fonction qui décompte toute les minutes et qu'on execute après le loop
       
        reglage = 0;
        lcd.setCursor(1, 7);
        lcd.write(' ');
      }
      Alarm.delay(400);
    }

    if ( not digitalRead (down)) // on a appuyé sur -
    {
      switch (reglage) {
        case 0: consigne --;
          if (consigne < 30) {
            consigne = 30;
          }
          break;
        case 1: heure --;
          if (heure < 0) {
            heure = 0;
          }
          break;
        case 2: minutes -= 5;
          if (minutes < 0) {
            minutes = 0;
          }
          break;
      }
      Alarm.delay(200);
    }
  }
  else // (arret == false) // si la variable arret = 0, le chronometre tourne
  {
    float temperature = getTemp();
    if (temperature < consigne) // si la temp est inf a la consigne
    {
      digitalWrite(relay, HIGH); // alors le relais s'allume
    }
    else
    {
      digitalWrite(relay, LOW);
    }

    if ( not digitalRead (center)) {
      arret = true;
      Alarm.disable(0);
      digitalWrite(relay, LOW);
      reglage = 0;
      lcd.setCursor(0, 0);
      lcd.write(0b111110);
      Alarm.delay(400);
    }
  }
}

// Fonction qui se répète toutes les minutes
void Repeats() {
  if(arret==false){
  
  int difmin = minutes - minute();
  int difheure = heure - hour();
 if (difmin > 0 or difheure > 0 or second()>0)
  {
    lcd.setCursor(1, 2);
    lcd.print(zero(difheure));
    lcd.write(':');
    lcd.print(zero(difmin));
    lcd.write(' ');
  }
//lcd.setCursor(1, 2);
//    lcd.print(zero(difmin));
//    lcd.write(':');
//    lcd.print(zero(60-second()));
//    lcd.write(' ');
//  }
  else
  {
    
    digitalWrite(relay, LOW);
    //Alarm.disable(0);

    // iterate over the notes of the melody:
    for (int thisNote = 0; thisNote < 8; thisNote++) { // Loop through the notes in the array.
      int noteDuration = 1000 / noteDurations[thisNote];
      NewTone(speaker, melody[thisNote], noteDuration); // Play thisNote for noteDuration.
      delay(noteDuration * 4 / 3); // Wait while the tone plays in the background, plus another 33% delay between notes.
    }
    lcd.setCursor(0, 0);
      lcd.write(0b111110);
      arret = true;
  }
}
}

float getTemp() {
  //returns the temperature from one DS18S20 in DEG Celsius

  byte data[12];
  byte addr[8];

  if ( !ds.search(addr)) {
    //no more sensors on chain, reset search
    ds.reset_search();
    return -1000;
  }

  if ( OneWire::crc8( addr, 7) != addr[7]) {
    Serial.println("CRC is not valid!");
    return -1000;
  }

  if ( addr[0] != 0x10 && addr[0] != 0x28) {
    Serial.print("Device is not recognized");
    return -1000;
  }

  ds.reset();
  ds.select(addr);
  ds.write(0x44, 1); // start conversion, with parasite power on at the end

  byte present = ds.reset();
  ds.select(addr);
  ds.write(0xBE); // Read Scratchpad


  for (int i = 0; i < 9; i++) { // we need 9 bytes
    data[i] = ds.read();
  }

  ds.reset_search();

  byte MSB = data[1];
  byte LSB = data[0];

  float tempRead = ((MSB << 8) | LSB); //using two's compliment
  float TemperatureSum = tempRead / 16;

  return TemperatureSum;

  static int counter = 0;

  // Write a piece of text on the first line...



}

String zero(int nombre)
{
  String texte = "";
  if (nombre < 10) {
    texte = String(0) + String(nombre);
  }
  else {
    texte = String(nombre);
  }
  return texte;
}

