﻿

import sys
import serial
from PyQt5 import QtCore, QtWidgets
from PyQt5.QtWidgets import *
from PyQt5.QtWidgets import QPushButton
from PyQt5.QtCore import QSize

ser = serial.Serial('/dev/ttyUSB0', 9600) 

#define general characteristics of the interface
class App(QWidget):
    def __init__(self):
        super().__init__()
        self.title = 'Week 12:Interface Tommaso Lombardi'
        self.left = 10
        self.top = 10
        self.width = 320
        self.height = 200
        self.initUI()

 #Add 2 buttons that make the function "ledOn" and "ledOff"

    def initUI(self):
        self.setWindowTitle(self.title)
        self.setGeometry(self.left, self.top, self.width, self.height)

        label = QLabel("Click on the button to turn on or off the LED", self)
        label.move(80, 80)

        button = QPushButton('Turn on LED', self)
        button.clicked.connect(self.ledOn)
        button.move(100,120)
        button.resize(100,32)

        button2 = QPushButton('Turn off LED', self)
        button2.clicked.connect(self.ledOff)
        button2.move(100,160)
        button2.resize(100,32)


        self.show()

#it defines what ledOn does once the software buttons are pressed

    def ledOn(self):
        #print(ser.name)   #debug    
        print('Led On')
        ser.write(b'1')
        
    def ledOff(self):
        print('Led Off')
        ser.write(b'0')

 
if __name__ == '__main__':
    app = QApplication(sys.argv)
    ex = App()
    sys.exit(app.exec_())

