/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Vector;

class SystemPrims
extends Primitives {
    static String[] primlist = new String[]{"resett", "0", "timer", "0", "eq", "2", "(", "0", ")", "0", "wait", "1", "true", "0", "false", "0", "hexw", "2", "octw", "2", "tab", "0", "classof", "1", "class", "1", "string", "1", "%nothing%", "0", "print", "1", "hexparse", "1", "scanhex", "3", "exec", "1", "getproperty", "1", "ignore", "1", "qsym", "1", "now", "0"};

    SystemPrims() {
    }

    @Override
    public String[] primlist() {
        return primlist;
    }

    @Override
    public Object dispatch(int n, Object[] objectArray, LContext lContext) {
        switch (n) {
            case 0: {
                return this.prim_resett(lContext);
            }
            case 1: {
                return this.prim_timer(lContext);
            }
            case 2: {
                return this.prim_eq(objectArray[0], objectArray[1], lContext);
            }
            case 3: {
                return this.prim_parleft(lContext);
            }
            case 4: {
                return this.prim_parright(lContext);
            }
            case 5: {
                return this.prim_wait(objectArray[0], lContext);
            }
            case 6: {
                return this.prim_true(lContext);
            }
            case 7: {
                return this.prim_false(lContext);
            }
            case 8: {
                return this.prim_hexw(objectArray[0], objectArray[1], lContext);
            }
            case 9: {
                return this.prim_octw(objectArray[0], objectArray[1], lContext);
            }
            case 10: {
                return this.prim_tab(lContext);
            }
            case 11: {
                return this.prim_classof(objectArray[0], lContext);
            }
            case 12: {
                return this.prim_class(objectArray[0], lContext);
            }
            case 13: {
                return this.prim_string(objectArray[0], lContext);
            }
            case 14: {
                return new Nothing();
            }
            case 15: {
                lContext.tyo.println(Logo.prs(objectArray[0]));
                return null;
            }
            case 16: {
                return this.prim_hexparse(objectArray[0], lContext);
            }
            case 17: {
                return this.prim_scanhex(objectArray[0], objectArray[1], objectArray[2], lContext);
            }
            case 18: {
                return this.prim_exec(objectArray[0], lContext);
            }
            case 19: {
                return this.prim_getProperty(objectArray[0], lContext);
            }
            case 20: {
                return null;
            }
            case 21: {
                return this.prim_qsym(objectArray[0], lContext);
            }
            case 22: {
                return this.prim_now(lContext);
            }
        }
        return null;
    }

    Object prim_resett(LContext lContext) {
        Logo.starttime = System.currentTimeMillis();
        return null;
    }

    Object prim_timer(LContext lContext) {
        return new Double(System.currentTimeMillis() - Logo.starttime);
    }

    Object prim_eq(Object object, Object object2, LContext lContext) {
        return new Boolean(object.equals(object2));
    }

    Object prim_parright(LContext lContext) {
        Logo.error("Missing \"(\"", lContext);
        return null;
    }

    Object prim_parleft(LContext lContext) {
        if (this.ipmnext(lContext.iline)) {
            return this.ipmcall(lContext);
        }
        Object object = Logo.eval(lContext);
        Object object2 = lContext.iline.next();
        if (object2 instanceof Symbol && ((Symbol)object2).pname.equals(")")) {
            return object;
        }
        Logo.error("Missing \")\"", lContext);
        return null;
    }

    boolean ipmnext(MapList mapList) {
        try {
            return ((Symbol)mapList.peek()).fcn.ipm;
        }
        catch (Exception exception) {
            return false;
        }
    }

    Object ipmcall(LContext lContext) {
        Vector<Object> vector = new Vector<Object>();
        lContext.cfun = (Symbol)lContext.iline.next();
        while (!this.finIpm(lContext.iline)) {
            vector.addElement(Logo.evalOneArg(lContext.iline, lContext));
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return Logo.evalSym(lContext.cfun, objectArray, lContext);
    }

    boolean finIpm(MapList mapList) {
        if (mapList.eof()) {
            return true;
        }
        Object object = mapList.peek();
        if (object instanceof Symbol && ((Symbol)object).pname.equals(")")) {
            mapList.next();
            return true;
        }
        return false;
    }

    Object prim_wait(Object object, LContext lContext) {
        double d = 10.0 * Logo.aDouble(object, lContext);
        int n = (int)d;
        for (int i = 0; i < n; ++i) {
            if (lContext.timeToStop) {
                return null;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    Object prim_hexw(Object object, Object object2, LContext lContext) {
        Logo.anInt(object, lContext);
        String string = Logo.prs(object, 16);
        int n = Logo.anInt(object2, lContext);
        String string2 = "00000000".substring(8 - n + string.length());
        return string2 + string;
    }

    Object prim_octw(Object object, Object object2, LContext lContext) {
        Logo.anInt(object, lContext);
        String string = Logo.prs(object, 8);
        int n = Logo.anInt(object2, lContext);
        String string2 = "00000000".substring(8 - n + string.length());
        return string2 + string;
    }

    Object prim_true(LContext lContext) {
        return new Boolean(true);
    }

    Object prim_false(LContext lContext) {
        return new Boolean(false);
    }

    Object prim_tab(LContext lContext) {
        return "\t";
    }

    Object prim_classof(Object object, LContext lContext) {
        return object.getClass();
    }

    Object prim_class(Object object, LContext lContext) {
        try {
            return Class.forName(Logo.prs(object));
        }
        catch (Exception exception) {
            return "";
        }
        catch (Error error) {
            return "";
        }
    }

    Object prim_string(Object object, LContext lContext) {
        return this.prstring(object);
    }

    String prstring(Object object) {
        if (object instanceof Number && Logo.isInt((Number)object)) {
            return Long.toString(((Number)object).longValue(), 10);
        }
        if (object instanceof String) {
            return "|" + (String)object + "|";
        }
        if (object instanceof Object[]) {
            String string = "";
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof Object[]) {
                    string = string + "[";
                }
                string = string + this.prstring(objectArray[i]);
                if (objectArray[i] instanceof Object[]) {
                    string = string + "]";
                }
                if (i == objectArray.length - 1) continue;
                string = string + " ";
            }
            return string;
        }
        return object.toString();
    }

    Object prim_hexparse(Object object, LContext lContext) {
        TokenStream tokenStream = new TokenStream(Logo.prs(object), true);
        return tokenStream.readList(lContext);
    }

    Object prim_scanhex(Object object, Object object2, Object object3, LContext lContext) {
        String string = (String)object;
        Object[] objectArray = (Object[])object2;
        Object[] objectArray2 = (Object[])object3;
        for (int i = 0; i < objectArray.length; ++i) {
            int n = ((Number)objectArray2[i * 2]).intValue();
            int n2 = ((Number)objectArray2[i * 2 + 1]).intValue() + n;
            String string2 = string.substring(n, n2);
            objectArray[i] = new Long(Long.parseLong(string2, 16));
        }
        return null;
    }

    Object prim_exec(Object object, LContext lContext) {
        String string = Logo.prs(object);
        String string2 = "";
        try {
            String string3;
            Process process = Runtime.getRuntime().exec(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = string2 + string3 + "\n";
            }
            while ((string3 = bufferedReader2.readLine()) != null) {
                string2 = string2 + string3 + "\n";
            }
        }
        catch (Exception exception) {
            Logo.error("exec: " + exception + " " + string, lContext);
        }
        return string2;
    }

    Object prim_getProperty(Object object, LContext lContext) {
        String string = System.getProperty(Logo.prs(object));
        if (string == null) {
            return "";
        }
        return string;
    }

    Object prim_qsym(Object object, LContext lContext) {
        return new QuotedSymbol(Logo.aSymbol(object, lContext));
    }

    Object prim_now(LContext lContext) {
        return new Double(new Date().getTime());
    }
}

