/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class MacSerialHandler
extends SerialHandler {
    String name;
    FileInputStream fis;
    FileOutputStream fos;

    @Override
    boolean openPort(String string) {
        this.closePort();
        if (!new File(string).exists()) {
            return false;
        }
        try {
            this.fos = new FileOutputStream(string);
            this.fis = new FileInputStream(string);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    boolean reopenPort() {
        return true;
    }

    @Override
    void closePort() {
        try {
            if (this.fos != null) {
                this.fos.close();
            }
            if (this.fis != null) {
                this.fis.close();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    @Override
    void writebyte(int n) {
        if (this.fos == null) {
            return;
        }
        try {
            this.fos.write(n);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    @Override
    void writebytes(byte[] byArray) {
        if (this.fos == null) {
            return;
        }
        try {
            this.fos.write(byArray);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    @Override
    void clearcom() {
        if (this.fis == null) {
            return;
        }
        try {
            while (this.fis.available() > 0) {
                this.fis.read();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    @Override
    int readbyte() {
        if (this.fis == null) {
            return -1;
        }
        try {
            if (this.fis.available() == 0) {
                return -1;
            }
            return this.fis.read();
        }
        catch (IOException iOException) {
            return -1;
        }
    }
}

