/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

class TokenStream {
    String str;
    int offset = 0;
    boolean hexread = false;

    TokenStream(String string) {
        this(string, false);
    }

    TokenStream(String string, boolean bl) {
        this.str = string;
        this.hexread = bl;
        this.skipSpace();
    }

    Object[] readList(LContext lContext) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        while (!this.eof() && (object = this.readToken(lContext)) != null) {
            vector.addElement(object);
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    Object readToken(LContext lContext) {
        String string = this.next();
        try {
            if (this.hexread) {
                return new Double(Long.parseLong(string, 16));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (string.length() > 2 && string.charAt(0) == '0' && string.charAt(1) == 'x') {
                return new Double(Long.parseLong(string.substring(2), 16));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (string.length() > 1 && string.charAt(0) == '$') {
                return new Double(Long.parseLong(string.substring(1), 16));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (string.length() > 1 && string.charAt(0) == '0') {
                return new Double(Long.parseLong(string.substring(1), 8));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (string.equals("]")) {
            return null;
        }
        if (Logo.aValidNumber(string)) {
            try {
                Double d = Double.valueOf(string);
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (string.charAt(0) == '\"') {
            return new QuotedSymbol(Logo.intern(string.substring(1), lContext));
        }
        if (string.charAt(0) == ':') {
            return new DottedSymbol(Logo.intern(string.substring(1), lContext));
        }
        if (string.equals("[")) {
            return this.readList(lContext);
        }
        if (string.charAt(0) == '|') {
            return string.substring(1);
        }
        return Logo.intern(string, lContext);
    }

    boolean startsWith(String string) {
        return this.str.startsWith(string, this.offset);
    }

    void skipToNextLine() {
        while (!this.eof() && "\n\r".indexOf(this.str.charAt(this.offset)) == -1) {
            ++this.offset;
        }
        this.skipSpace();
    }

    void skipSpace() {
        while (!this.eof() && " ;,\t\r\n".indexOf(this.str.charAt(this.offset)) != -1) {
            if (this.peekChar().equals(";")) {
                while (!this.eof() && "\n\r".indexOf(this.str.charAt(this.offset)) == -1) {
                    ++this.offset;
                }
                continue;
            }
            ++this.offset;
        }
    }

    String nextLine() {
        String string = "";
        while (!this.eof() && ";\n\r".indexOf(this.peekChar()) == -1) {
            string = string + this.nextChar();
        }
        this.skipSpace();
        return string;
    }

    String next() {
        String string = "";
        if (!this.delim(this.peekChar())) {
            while (!this.eof() && !this.delim(this.peekChar())) {
                if (this.peekChar().equals("|")) {
                    string = string + "|" + this.getVbarString();
                    this.skipSpace();
                    return string;
                }
                string = string + this.nextChar();
            }
        } else {
            string = this.nextChar();
        }
        this.skipSpace();
        return string;
    }

    String getVbarString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.nextChar();
        while (!this.eof()) {
            if (this.peekChar().equals("|")) {
                this.nextChar();
                break;
            }
            stringBuffer.append(this.nextChar());
        }
        return stringBuffer.toString();
    }

    boolean delim(String string) {
        char c = string.charAt(0);
        return "()[] ,\t\r\n".indexOf(c) != -1;
    }

    String peekChar() {
        return String.valueOf(this.str.charAt(this.offset));
    }

    String nextChar() {
        return String.valueOf(this.str.charAt(this.offset++));
    }

    boolean eof() {
        return this.str.length() == this.offset;
    }
}

