/*
 * Decompiled with CFR 0.152.
 */
public class PCSerialHandler
extends SerialHandler {
    static final String[] parityLetter = new String[]{"N", "E", "O", "M", "S"};

    @Override
    boolean openPort(String string) {
        this.closePort();
        return PCSerialHandler.nOpenPort(string) != 0;
    }

    @Override
    void closePort() {
        PCSerialHandler.nClosePort();
    }

    @Override
    String getPortName(int n, int n2) {
        String string = PCSerialHandler.nGetPortName(n, n2);
        int n3 = string.lastIndexOf(40);
        int n4 = string.lastIndexOf(41);
        if (n3 == -1) {
            return "";
        }
        if (n4 == -1) {
            return "";
        }
        return "\\\\.\\" + string.substring(n3 + 1, n4);
    }

    @Override
    int readbyte() {
        return PCSerialHandler.nReadbyte();
    }

    @Override
    void clearcom() {
        PCSerialHandler.nClearcom();
    }

    @Override
    void writebyte(int n) {
        PCSerialHandler.nWritebyte(n);
    }

    @Override
    void writebytes(byte[] byArray) {
        PCSerialHandler.nWritebytes(byArray);
    }

    @Override
    void usbInit() {
        PCSerialHandler.nUsbInit();
    }

    @Override
    int portHandle() {
        return PCSerialHandler.nPortHandle();
    }

    @Override
    void modemCtrl(int n, int n2) {
        PCSerialHandler.nModemCtrl(n, n2);
    }

    @Override
    void setSerialPortParams(int n, int n2, int n3, int n4) {
        String string = "baud=" + n + " parity=" + parityLetter[n4];
        string = string + " data=" + n2 + " stop=" + n3;
        PCSerialHandler.nSetCommState(string);
    }

    static native int nOpenPort(String var0);

    static native boolean nClosePort();

    static native boolean nSetCommState(String var0);

    static native int nReadbyte();

    static native boolean nClearcom();

    static native boolean nWritebyte(int var0);

    static native boolean nWritebytes(byte[] var0);

    static native boolean nUsbInit();

    static native int nPortHandle();

    static native String nGetPortName(int var0, int var1);

    static native boolean nModemCtrl(int var0, int var1);

    static {
        if (System.getProperty("os.arch").toLowerCase().equals("amd64")) {
            System.loadLibrary("javaserial64-v2");
        } else {
            System.loadLibrary("javaserial-v2");
        }
    }
}

