/*
 * Decompiled with CFR 0.152.
 */
class SerialPrims
extends Primitives {
    static String[] primlist = new String[]{"openport", "1", "closeport", "0", "portname", "2", "setportparams", "4", ".send", "1", "sendl", "1", ".recc", "0", "clearcom", "0", "usbinit", "0", "porthandle", "0", "windows?", "0"};
    static SerialHandler handler;

    SerialPrims() {
    }

    @Override
    public String[] primlist() {
        return primlist;
    }

    @Override
    public Object dispatch(int n, Object[] objectArray, LContext lContext) {
        switch (n) {
            case 0: {
                return this.prim_openport(objectArray[0], lContext);
            }
            case 1: {
                return this.prim_closeport(lContext);
            }
            case 2: {
                return this.prim_portname(objectArray[0], objectArray[1], lContext);
            }
            case 3: {
                return this.prim_setportparams(objectArray[0], objectArray[1], objectArray[2], objectArray[3], lContext);
            }
            case 4: {
                return this.prim_send(objectArray[0], lContext);
            }
            case 5: {
                return this.prim_sendl(objectArray[0], lContext);
            }
            case 6: {
                return this.prim_recc(lContext);
            }
            case 7: {
                return this.prim_clearcom(lContext);
            }
            case 8: {
                return this.prim_usbinit(lContext);
            }
            case 9: {
                return this.prim_porthandle(lContext);
            }
            case 10: {
                return new Boolean(System.getProperty("os.name").toLowerCase().startsWith("windows"));
            }
        }
        return null;
    }

    Object prim_openport(Object object, LContext lContext) {
        String string = Logo.prs(object);
        if (!handler.openPort(string)) {
            Logo.error("can't open port " + string, lContext);
        }
        return null;
    }

    Object prim_closeport(LContext lContext) {
        handler.closePort();
        return null;
    }

    Object prim_portname(Object object, Object object2, LContext lContext) {
        int n = Logo.anInt(object, lContext);
        int n2 = Logo.anInt(object2, lContext);
        return handler.getPortName(n, n2);
    }

    Object prim_setportparams(Object object, Object object2, Object object3, Object object4, LContext lContext) {
        int n = Logo.anInt(object, lContext);
        int n2 = Logo.anInt(object2, lContext);
        int n3 = Logo.anInt(object3, lContext);
        int n4 = Logo.anInt(object4, lContext);
        handler.setSerialPortParams(n, n2, n3, n4);
        return null;
    }

    Object prim_send(Object object, LContext lContext) {
        handler.writebyte(Logo.anInt(object, lContext));
        return null;
    }

    Object prim_sendl(Object object, LContext lContext) {
        Object[] objectArray = Logo.aList(object, lContext);
        byte[] byArray = new byte[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            byArray[i] = (byte)Logo.anInt(objectArray[i], lContext);
        }
        handler.writebytes(byArray);
        return null;
    }

    Object prim_recc(LContext lContext) {
        return new Double(handler.readbyte());
    }

    Object prim_clearcom(LContext lContext) {
        handler.clearcom();
        return null;
    }

    Object prim_porthandle(LContext lContext) {
        return new Double(handler.portHandle());
    }

    Object prim_usbinit(LContext lContext) {
        handler.usbInit();
        return null;
    }

    static {
        try {
            String string = System.getProperty("os.name").toLowerCase().startsWith("windows") ? "PCSerialHandler" : "MacSerialHandler";
            Class<?> clazz = Class.forName(string);
            handler = (SerialHandler)clazz.newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

