
//sensor readout
#include <Wire.h>

long accelX, accelY, accelZ;
float gForceX, gForceY, gForceZ;

long gyroX, gyroY, gyroZ;
float rotX, rotY, rotZ;

int minVal=265; 
int maxVal=402;

double tiltX; 
double tiltY; 
double tiltZ;

//grab control
int relais = 6;
int grab = 5;
int grabstatus = 0;


//servos
#include <Servo.h>
Servo servo1;
Servo servo2;
Servo servo3;
int position1 = 90;
int leftspeedZ = 90;
int rightspeedZ = 90;
int position2 = 90;
int position3 = 90;
int servopin1 = 8;
int servopin2 = 9;
int servopin3 = 10;



//movedelay
int movedelay = 4;
int movedelaystatus = 0;




void setup() {
  Serial.begin(9600);
  Wire.begin();
  setupMPU();
  servo1.attach(8);
  servo2.attach(9);
  servo3.attach(10);
pinMode(relais, OUTPUT);
pinMode(grab, INPUT);
pinMode(movedelay, INPUT);
}


void loop() 
{

recordAccelRegisters();
recordGyroRegisters();
movedelaystatus=digitalRead(movedelay);
if(movedelaystatus==LOW)
{
grabcontrol();
servocontrol();
}
else{
  servo1.write(90);
  servo2.write(90);
  servo3.write(90);
}
printData();

 
}

void setupMPU(){
  Wire.beginTransmission(0b1101000); //This is the I2C address of the MPU (b1101000/b1101001 for AC0 low/high datasheet sec. 9.2)
  Wire.write(0x6B); //Accessing the register 6B - Power Management (Sec. 4.28)
  Wire.write(0b00000000); //Setting SLEEP register to 0. (Required; see Note on p. 9)
  Wire.endTransmission();  
  Wire.beginTransmission(0b1101000); //I2C address of the MPU
  Wire.write(0x1B); //Accessing the register 1B - Gyroscope Configuration (Sec. 4.4) 
  Wire.write(0x00000000); //Setting the gyro to full scale +/- 250deg./s 
  Wire.endTransmission(); 
  Wire.beginTransmission(0b1101000); //I2C address of the MPU
  Wire.write(0x1C); //Accessing the register 1C - Acccelerometer Configuration (Sec. 4.5) 
  Wire.write(0b00000000); //Setting the accel to +/- 2g
  Wire.endTransmission(); 
}

void recordAccelRegisters() {
  Wire.beginTransmission(0b1101000); //I2C address of the MPU
  Wire.write(0x3B); //Starting register for Accel Readings
  Wire.endTransmission();
  Wire.requestFrom(0b1101000,6); //Request Accel Registers (3B - 40)
  while(Wire.available() < 6);
  accelX = Wire.read()<<8|Wire.read(); //Store first two bytes into accelX
  accelY = Wire.read()<<8|Wire.read(); //Store middle two bytes into accelY
  accelZ = Wire.read()<<8|Wire.read(); //Store last two bytes into accelZ
  processAccelData();
  processAngleData();
}

void processAccelData(){
  gForceX = accelX / 16384.0;
  gForceY = accelY / 16384.0; 
  gForceZ = accelZ / 16384.0;
  
}

void processAngleData()
{
int xAng = map(accelX,minVal,maxVal,-90,90);
int yAng = map(accelY,minVal,maxVal,-90,90);
int zAng = map(accelZ,minVal,maxVal,-90,90);
tiltX= RAD_TO_DEG * (atan2(-yAng+180, -zAng+180)+PI);
tiltY= RAD_TO_DEG * (atan2(-xAng+180, -zAng+180)+PI);
tiltZ= RAD_TO_DEG * (atan2(-yAng+180, -xAng+180)+PI);
}

void recordGyroRegisters() {
  Wire.beginTransmission(0b1101000); //I2C address of the MPU
  Wire.write(0x43); //Starting register for Gyro Readings
  Wire.endTransmission();
  Wire.requestFrom(0b1101000,6); //Request Gyro Registers (43 - 48)
  while(Wire.available() < 6);
  gyroX = Wire.read()<<8|Wire.read(); //Store first two bytes into accelX
  gyroY = Wire.read()<<8|Wire.read(); //Store middle two bytes into accelY
  gyroZ = Wire.read()<<8|Wire.read(); //Store last two bytes into accelZ
  processGyroData();
}

void processGyroData() {
  rotX = gyroX / 131.0;
  rotY = gyroY / 131.0; 
  rotZ = gyroZ / 131.0;
}

void printData() {

  Serial.print(" X=");
  Serial.print(rotX);
  Serial.print(" Y=");
  Serial.print(rotY);
  Serial.print(" Z=");
  Serial.print(rotZ);
  Serial.print("         gForceX=");
  Serial.print(gForceX);
  Serial.print(" gForceY=");
  Serial.print(gForceY);
  Serial.print(" gForceZ=");
  Serial.print(gForceZ);
  Serial.print("         tiltX=");
  Serial.print(tiltX);
  Serial.print(" tiltY=");
  Serial.print(tiltY);
  Serial.print(" tiltZ=");
  Serial.println(tiltZ);
 }
 
 void servocontrol()
{
  //Servo1
    while(rotZ>10)
    {
    leftspeedZ = map(rotZ,15,200,90,120);
    servo1.write(leftspeedZ);
    recordGyroRegisters();
    }
  
    while(rotZ<-10)
   {
    rightspeedZ = map(rotZ,-15,-200,90,60);
    servo1.write(rightspeedZ);
    recordGyroRegisters();
    }
  
  
//Servo2  
position2 = map(tiltY,135,225,100,80);
 if((position2<84) && (position2>96))
  {
    servo2.write(90);
  }
else
  {
    servo2.write(position2);
  }
  
  //Servo3
  position3 = map(tiltX,135,225,100,0);
  if((position3<84) && (position3>96))
  {
    servo3.write(90);
  }
else
  {
   
    servo3.write(position3);
  }
}
 
 void grabcontrol()
{
  grabstatus=digitalRead(grab);
if (grabstatus == LOW)
{
digitalWrite(relais, LOW);
}
else
{
digitalWrite(relais, HIGH);
}
}