/* Fab Academy stepper motor stuff
 *  David McCallum, 2018
 *  sintheta.org
 *  Code adapted from http://aconcaguasci.blogspot.nl/2016/11/arduino-cnc-shield-control-stepper.html
 */

#define EN        0 

//Direction pin
#define X_DIR     4

//Step pin
#define X_STP     2


//DRV8825
int delayTime=30; //Delay between each pause (uS)
int stps=1;// Steps to move


void step(boolean dir, byte dirPin, byte stepperPin, int steps)

{

  digitalWrite(dirPin, dir);

  delay(100);

  for (int i = 0; i < steps; i++) {

    digitalWrite(stepperPin, HIGH);

    delayMicroseconds(delayTime); 

    digitalWrite(stepperPin, LOW);

    delayMicroseconds(delayTime); 

  }

}

void setup(){

  pinMode(X_DIR, OUTPUT); pinMode(X_STP, OUTPUT);

 
  pinMode(EN, OUTPUT);

  digitalWrite(EN, LOW);


  //pinMode(1, OUTPUT);
  //digitalWrite(1,HIGH);
  //pinMode(5, OUTPUT);
  //digitalWrite(5,LOW);

}

void loop(){

  step(false, X_DIR, X_STP, stps); //X, Clockwise
 
  //delay(100);

  //step(true, X_DIR, X_STP, stps); //X, Counterclockwise
 
  //delay(100);

}
