/*  
 *  Performing the Machine
 *  Fab Academy Final Project
 *  Full project details at http://fabacademy.org/2018/labs/fablabamsterdam/students/david-mccallum/finalProject.html
 *  
 *  v .02
 *  
 *  David McCallum, 2018
 *  sintheta.org
 *  
 *  This code is licensed under a Creative Commons Attribution-NonCommercial 4.0 International License.
 *  
 */


/*
 * 
 * GCODE EXPRESSIONS
 * 
 * formating: {speed, X, Y}
 * 
 */
const float rod0[][3] = {
{9000,102.804,101.656},
{1200,102.944,101.722},
{1200,103.075,101.814},
{1200,103.182,101.921},
{1200,103.274,102.052},
{1200,103.34,102.192},
{1200,103.38,102.347}


};


const float rod1[][3] = {
{9000,100.55,100.55},
{3600,100.62,100.62},
{7200,100.595,100.595},
{7200,101.175,100.212},
{7200,101.592,100.018},
{7200,102.038,99.898},
{7200,102.496,99.858}

};

const float rod2[][3] = {
{9000,103.606,95.792},
{1800,104.232,95.926},
{1800,104.842,96.117},
{1800,105.424,96.363},
{1800,105.982,96.662},
{1800,106.526,97.023},
{1800,107.011,97.416}

};

const float rod3[][3] = {
{9000,92.694,91.434},
{1800,93.713,90.608},
{1800,94.351,90.142},
{1800,94.947,89.788},
{1800,96.101,89.171},
{1800,96.816,88.835},
{1800,97.429,88.613}

};

const float rod4[][3] = {
{9000,100.011,96.604},
{1200,100.583,96.394},
{1200,101.154,96.243},
{1200,101.742,96.145},
{1200,102.349,96.102},
{1200,102.946,96.117},
{5400,102.939,96.216}
};

const float rod5[][3] = {
{9000,102.98,101.165},
{1200,103.204,101.27},
{1200,103.412,101.416},
{1200,103.58,101.584},
{1200,103.726,101.792},
{1200,103.831,102.016},
{1200,103.893,102.252}
};


/*
 * 
 * VARIABLES
 * 
 */


const int ledPin = 9;

char okString[3];
int stringPos = 0;

int currentLocation[2] = {50,50};


const int playThreshold = 50;    // what sensor value is needed to start playing?

const int upperLower[2] = {.5,2}; // speed multiplier

const int sensorMax = 800;    // the sensors don't go quite to 1024, so this is about a maximum

int sensors[6];     // the analogRead value of each of the sensors
int whosPlaying = -1;   // which sensor is playing now, -1 is none.



/* 
 *  
 *  FUNCTIONS
 *  
 */

// move the printer's extruder
void goToCentre() {
  Serial.write("G1 F9000 X100 Y100\n");
  //currentLocation[0] = 50;
  //currentLocation[1] = 50;
}

//Home the X and Y axes
void goHome() {
  Serial.write("G28 X Y\n");
}


// this function is never used… but will be one day
void waitForOK() {
  
  // wait for something in serial
  while (!Serial.available()) {
    // maybe have a timeout here?
  }

  // read once something's here
  while(Serial.available()) {
    inByte = Serial.read();  
    okString[stringPos] = inByte;
    stringPos++;
  }
  stringPos = 0;    // reset the string reader

  // *** if it's not OK.… some error checking


  
}

// See if the printer is connected
void checkConnected() {
  
  // If there is no serial data
  while (!Serial.available()) {
    Serial.write("G4 P0\n");     // send harmless gcode
    delay(500);               // wait a bit, maybe the machine is booting
  }

  //When there's finally serial data
  if (Serial.available()) {      
    while (Serial.available()) {    // empty the buffer by continuously reading from it until it's empty
      Serial.read();
    }
  }
}

// put sensor values into the array
void getSensors() { 
  for (int i = 0; i < 6; i++) { 
    sensors[i] = analogRead(i); 
    } 
}


// decide which sensor is active
void listening() {
  
  for (int i = 0; i < 6; i++) { 
    
    if (sensors[i] > playThreshold) { 
      whosPlaying = i; 
      }
   
  }
}



void printSensors() {

  for (int i = 0; i < 6; i++) { 
    Serial.print("Sensors: ");
    Serial.print(sensors[i]);
    Serial.print('\t');

  }
  Serial.println();
}


// Select which expression to play, and print out its lines.
void playThatFunkyMusic(int whichRod, float playSpeed) {

  if (whichRod == 0) { 
    for (int i = 0; i < (sizeof(rod0) / 4 / 3)  ; i++) {
      float nowSpeed = rod0[i][0] * playSpeed;
      Serial.print("G1 F");
      Serial.print(nowSpeed);
      Serial.print(" X");
      Serial.print(rod0[i][1]);
      Serial.print(" Y");
      Serial.print(rod0[i][2]);
      Serial.print("\n");
      }     
  }  
  else if (whichRod == 1) { 
    for (int i = 0; i < (sizeof(rod1) / 4 / 3)  ; i++) {
      float nowSpeed = rod1[i][0] * playSpeed;
      Serial.print("G1 F");
      Serial.print(nowSpeed);
      Serial.print(" X");
      Serial.print(rod1[i][1]);
      Serial.print(" Y");
      Serial.print(rod1[i][2]);
      Serial.println();
      }     
  } 
  else if (whichRod == 2) { 
    for (int i = 0; i < (sizeof(rod2) / 4 / 3)  ; i++) {
      float nowSpeed = rod2[i][0] * playSpeed;
      Serial.print("G1 F");
      Serial.print(nowSpeed);
      Serial.print(" X");
      Serial.print(rod2[i][1]);
      Serial.print(" Y");
      Serial.print(rod2[i][2]);
      Serial.println();
      }     
  } 
  else if (whichRod == 3) { 
    for (int i = 0; i < (sizeof(rod3) / 4 / 3)  ; i++) {
      float nowSpeed = rod3[i][0] * playSpeed;
      Serial.print("G1 F");
      Serial.print(nowSpeed);
      Serial.print(" X");
      Serial.print(rod3[i][1]);
      Serial.print(" Y");
      Serial.print(rod3[i][2]);
      Serial.println();
      }     
  } 

  else if (whichRod == 4) { 
    for (int i = 0; i < (sizeof(rod4) / 4 / 3)  ; i++) {
      float nowSpeed = rod4[i][0] * playSpeed;
      Serial.print("G1 F");
      Serial.print(nowSpeed);
      Serial.print(" X");
      Serial.print(rod4[i][1]);
      Serial.print(" Y");
      Serial.print(rod4[i][2]);
      Serial.println();
      }     
  } 

  else if (whichRod == 5) { 
    for (int i = 0; i < (sizeof(rod5) / 4 / 3)  ; i++) {
      float nowSpeed = rod5[i][0] * playSpeed;
      Serial.print("G1 F");
      Serial.print(nowSpeed);
      Serial.print(" X");
      Serial.print(rod5[i][1]);
      Serial.print(" Y");
      Serial.print(rod5[i][2]);
      Serial.println();
      }     
  } 
}



void shine() {
  analogWrite(ledPin, map(sensors[whosPlaying], 0, sensorMax, 0, 255));
}



/* 
 *  
 *  SETUP
 *  
 */


void setup() {

  Serial.begin(250000); // hardware serial to printer

  //checkConnected();

  goHome();
  goToCentre();

}

/* 
 *  
 *  LOOP
 *  
 *  
 */

void loop() {

  getSensors();   // read the sensors
  listening();    // is someone playing?
  shine();

  if (whosPlaying != -1) {

    int maxValue = sensors[whosPlaying];    // the highest value the sensor has put out  

    while (sensors[whosPlaying] > playThreshold) {    // find the highest value, quit when it's below the threshold
      maxValue = max(maxValue, sensors[whosPlaying]);   // take the highest value
      sensors[whosPlaying] = analogRead(whosPlaying);   // read the value again
      shine();
    }

    float speedMultiplier = (maxValue/float(sensorMax)) * (upperLower[1] - upperLower[0]) + upperLower[0];  // scale the sensor value

    playThatFunkyMusic(whosPlaying, speedMultiplier);    // play the sequence

    whosPlaying = -1; // reset who's playing
    
    delay(100);

  }

}




/*
 *  Test functions
 */




void testSensorJump() {
  int sensor1data = analogRead(0);

  if (sensor1data > 400) {
    int randX = random(100);
    int randY = random(100);

    ser.print("G1 X");
    ser.print(randX);
    ser.print(" Y");
    ser.print(randY);
    ser.print("\n");

    Serial.print("G1 X");
    Serial.print(randX);
    Serial.print(" Y");
    Serial.print(randY);
    Serial.print("\n");

  }

  delay(250);
  

}


// listen to softwareserial, echo is out the FTDI serial
void testEchoSerial() {
  while (ser.available()) { Serial.write(ser.read()); }
}




void serialBridge() {
  while (Serial.available()) { ser.write(Serial.read()); }
  while (ser.available()) { Serial.write(ser.read()); }
}



void testSerialBlink() {
  while (Serial.available()) {
    Serial.read();
    digitalWrite(13, HIGH);
    delay(10);
    digitalWrite(13, LOW);
    delay(10);

  }



}




