#include <SoftwareSerial.h>

SoftwareSerial mySerial(PIN_A0, PIN_A1);

#define PIN_BUTTON A2
#define PIN_PHOTO A3
#define PIN_TEMP A4
#define PIN_SWT A5

void setup() {
  mySerial.begin(9600);
  pinMode(PIN_BUTTON, INPUT);
  pinMode(PIN_PHOTO, INPUT);
  pinMode(PIN_TEMP, INPUT);
  pinMode(PIN_SWT, INPUT);
}

void loop() {
  mySerial.print("Temp: ");
  mySerial.print((analogRead(PIN_TEMP) * 25 - 2050) / 100);
  mySerial.print("  Button: ");
  mySerial.print(buttonPressed(analogRead(PIN_BUTTON)));
  mySerial.print("  Photo: ");
  mySerial.print(analogRead(PIN_PHOTO)>800?1:0);
  mySerial.print("  Switch: ");
  mySerial.print(digitalRead(PIN_SWT));
  mySerial.println();
  delay(1000);
}

int buttonPressed(int val) {
  if (val < 10)   return 1;
  if (val < 520)  return 2;
  if (val < 700)  return 3;
  return 0;
}
