//A test to have the LED on continuously and run the motors continuously.
//By Rick den Hengst.

#include <avr/io.h>
#include <util/delay.h>
#define F_CPU 20000000UL	//Clock in Hz

#define LED (1<<PA7)
#define ML (1<<PB1)
#define MR (1<<PB2)


void LEDon()
{
    PORTA |= 0b10000000; //Turn the LED on
    //PORTA |= LED;
}

void LEDoff()
{
    PORTA &= ~0b10000000; //turn the LED off
    //PORTA &= ~LED;
}

void RIGHTMOTOR()
{
    PORTB = 0b0100; //Run Right Motor
}

void LEFTMOTOR()
{
    PORTB = 0b0010; //Run Left Motor
}

void MOTORBOTH()
{
    PORTB = 0b0110; //Run Both Motors
}

void MOTORoff()
{
    PORTB = 0b0000; //Turn Motors Off
}

int LEFT(void)
{
    LEDoff(); //clear all previous lights
    MOTORoff(); //Turn Motors Off
    LEDon(); //start first blink
    _delay_ms(100); //100 ms on
    LEDoff(); //Stop first blink
    LEDon(); //Start second blink
    _delay_ms(100); //100 ms on
    LEDoff(); //Stop Second blink
    LEDon(); //Start third blink
    _delay_ms(100); //100 ms on
    LEDoff();
    RIGHTMOTOR(); //Run right motor
    _delay_ms(50); //50md motor run time
    MOTORoff(); //Turn Motors Off
    _delay_ms(25); //this delay is to give a pause between blinks
}

int RIGHT(void)
{
    LEDoff(); //clear all previous lights
    MOTORoff(); //Turn Motors Off
    LEDon(); //start first blink
    _delay_ms(100); //100 ms on
    LEDoff(); //Stop first blink
    LEDon(); //Start second blink
    _delay_ms(100); //100 ms on
    LEDoff(); //Stop Second blink
    LEDon(); //Start third blink
    _delay_ms(100); //100 ms on
    LEDoff();
    LEFTMOTOR(); //Run left motor
    _delay_ms(50); //50ms motor run time
    MOTORoff(); //Turn Motors Off
    _delay_ms(25); //this delay is to give a pause between blinks
}

int STRAIGHT(void)
{
    LEDoff(); //clear all previous lights
    MOTORoff(); //Turn Motors Off
    LEDon(); //start first blink
    _delay_ms(100); //5 ms on
    LEDoff(); //Stop first blink
    LEDon(); //Start second blink
    _delay_ms(100); //5 ms on
    LEDoff(); //Stop Second blink
    LEDon(); //Start third blink
    _delay_ms(100); //5 ms on
    LEDoff();
    MOTORBOTH(); //Run both motors
    _delay_ms(50); //50md motor run time
    MOTORoff(); //Turn Motors Off
    _delay_ms(25); //this delay is to give a pause between blinks
}


//**********************MAIN*********************


int main(void)
{
    // ########## config PORT B#############
    
    //        3    2   1  0
    //	    [ X   MR   ML X]
    
    
    
	DDRB  = 0b0110;        // Output=1, Input=0
    //DDRB = ML| MR;
	PORTB = 0b0000;        // preset
    
    // ########## config PORT A#############
    
    //      [ 7  6  5  4  3  2   1  0]
    //	    [LED X  X  X  X  X  RT LT]
    
    
	DDRA  = 0b1000000;        // Output=1, Input=0
    //DDRA = LED;
    
    while (1)
    {
        LEFT();
        RIGHT();
        STRAIGHT();
        _delay_ms(1000); // Wait 100 ms before starting over.
    }
}
