// Lightbug V1.1 ATtiny 44
// By Rick den Hengst
// Based on:
// Lightbot V1.1   ATtiny 13/25/85
// Originally by Nicomania.de
// With bits and pieces lifted from Neil Gershenfeld, MIT
// And with help from Bas Withagen, FabLab Amsterdam

// ************** Defines **************************************************

#include <avr/io.h>
#include <util/delay.h>
#define F_CPU 8000000UL	//Clock in Hz

#define LED (1<<PA7)
#define ML (1<<PB1)
#define MR (1<<PB2)

// ************** Variables *************************************************

volatile int i,k,z;	// Count & Buffer
volatile int CycleCount=10;

volatile int tolerance=30;	// Tolerance

volatile int speedL=200;  	// PWM Motor Speed Left (0-255)
volatile int speedR=200;  	// PWM Motor Speed Right (0-255)
volatile int speedS=180;  	// PWM Motor Speed Straight (0-255)

volatile int impulsL=200;  // Pulse duration Motor left (in ms)
volatile int impulsR=200;  // Pulse duration Motor right (in ms)
volatile int impulsS=95;  // Pulse duration Motor Straight (in ms)

volatile int ul=3;  // U-Turn Impulse left
volatile int ur=4;  // U-Turn Impulse right


// ************** Function: light (0-1023) **********************************

int measured (int channel)
{

  	int a=5, f=a, j=a;	// a>0 Number of measuring cycles
	long int value=0, value1=0, value2=0 ;
	
	ADCSRA=0x80; 		// ADC turned on, no Prescale 
	ADMUX=channel;		// Pin select
	ADCSRA |=_BV(ADSC); 	// Start Dummy Measurement
	while (ADCSRA & (1<<ADSC));	// Wait for completed conversion

	while(j){
  		
		while(f){
			ADCSRA |=_BV(ADSC); 		// Start Measurement
			while (ADCSRA & (1<<ADSC));	// Wait for completed conversion
			value+=ADCW;			// Value handover
			f--;
		}
		
		value1 = value/a;		// Average value
		value2 += value1;
		j--;
	}
	
	value=(value2/a);

	return (value);
}

int lightL(void) 
{
	return (1023-measured(0));	// invert
}

int lightR(void)
{
	return (1023-measured(1));	// invert
}

// ************** Function: Movement ****************************************

void straight(void) 
{
	k=255-speedS;
    for(i=impulsS;i>0;i--)
	{
    	PORTB |= 0b0110;
		for (z=0; z<speedS; z++);
		PORTB &= 0b1001;
		for (z=0; z<k; z++);
    }
	_delay_ms(100);
}

void left(void) 
{
	k=255-speedL;
    for(i=impulsL;i>0;i--)
	{
    	PORTB |= 0b0010;
		for (z=0; z<speedL; z++);
		PORTB &= 0b1101;
		for (z=0; z<k; z++);
    }
	_delay_ms(100);
}

void right(void) 
{
	k=255-speedR;
    for(i=impulsR;i>0;i--)
	{
    	PORTB |= 0b0100;
		for (z=0; z<speedR; z++);
		PORTB &= 0b1011;
		for (z=0; z<k; z++);
    }
	_delay_ms(100);
}

void turn(void)
{
    int t;
	if (lightL()>lightR())
		{
			for(t = 0; t<=ul ; t++)
			{
		
				left();
				_delay_ms(10);
			}
		}
	else{
			for(t = 0; t<=ur ; t++)
			{
		
				right();
				_delay_ms(10);
			}
		}
}

void ini(void)
{
	int pos=0;
	int maxSense=0;
	int i360=9;
    int curpos;

	for(curpos=0;curpos<i360;curpos++)
	{		
		int iLight = lightL();
		if(iLight>maxSense)
		{
			maxSense=iLight;
			pos=curpos;
		}
		right();
		_delay_ms(100);
	}
	
	while(pos>0)
	{
		right();
		pos--;
		_delay_ms(100);
	}
}

// ************** Function: LED (On, Off or in ms) *****************

void led(int l) 
{
	if (l==1)      	// LED on
	{
		PORTA &= 0b01111111;	//low
	}
	else if (l==0)  // LED off
	{
		PORTA |= 0b10000000;	// high
	}
	else    		// LED blink
	{		
		PORTA &= 0b01111111;	//low
		for (i=l/10; i>0; i--) _delay_ms(10);
		PORTA |= 0b10000000;	// high
	}
}

// ************** MAIN ******************************************************

int main(void)
{
    
    // set clock divider to /1
    //
    CLKPR = (1 << CLKPCE);
    CLKPR = (0 << CLKPS3) | (0 << CLKPS2) | (0 << CLKPS1) | (0 << CLKPS0);

// ########## config PORT B#############

//        3    2   1  0
//	    [ X   MR   ML X]


	DDRB  = 0b0110;        // Output=1, Input=0
	PORTB = 0b0000;        // preset
    
// ########## config PORT A#############
    
//      [ 7  6  5  4  3  2   1  0]
//	    [LED X  X  X  X  X  RT LT]
    
    
	DDRA  = 0b10000000;        // Output=1, Input=0
	PORTA = 0b10000011;        // preset

	led(1000); _delay_ms(250);

// ########## Move ############

	ini();
    while(1)
    {
				if(lightL() > lightR() + tolerance)  	// When left is brighter
				{
					right();
				}else if(lightR() > lightL() + tolerance)		// When right is brighter
				{
					left();
                //}else if(lightR() - lightL() <  tolerance)   // When light is equal
				//{
				//	straight();
				}else
				{
					led(10); _delay_ms(100); led(10); _delay_ms(100); led(10); _delay_ms(250); _delay_ms(250); _delay_ms(250); _delay_ms(250);
				}
				_delay_ms(80);
	}
}
